/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationsignals.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationsignals.model.MetricDataQuery;
import com.amazonaws.services.applicationsignals.model.ServiceLevelIndicatorMetricType;
import com.amazonaws.services.applicationsignals.model.transform.ServiceLevelIndicatorMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceLevelIndicatorMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> keyAttributes;
    private String operationName;
    private String metricType;
    private List<MetricDataQuery> metricDataQueries;

    public Map<String, String> getKeyAttributes() {
        return this.keyAttributes;
    }

    public void setKeyAttributes(Map<String, String> keyAttributes) {
        this.keyAttributes = keyAttributes;
    }

    public ServiceLevelIndicatorMetric withKeyAttributes(Map<String, String> keyAttributes) {
        this.setKeyAttributes(keyAttributes);
        return this;
    }

    public ServiceLevelIndicatorMetric addKeyAttributesEntry(String key, String value) {
        if (null == this.keyAttributes) {
            this.keyAttributes = new HashMap<String, String>();
        }
        if (this.keyAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.keyAttributes.put(key, value);
        return this;
    }

    public ServiceLevelIndicatorMetric clearKeyAttributesEntries() {
        this.keyAttributes = null;
        return this;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ServiceLevelIndicatorMetric withOperationName(String operationName) {
        this.setOperationName(operationName);
        return this;
    }

    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public ServiceLevelIndicatorMetric withMetricType(String metricType) {
        this.setMetricType(metricType);
        return this;
    }

    public ServiceLevelIndicatorMetric withMetricType(ServiceLevelIndicatorMetricType metricType) {
        this.metricType = metricType.toString();
        return this;
    }

    public List<MetricDataQuery> getMetricDataQueries() {
        return this.metricDataQueries;
    }

    public void setMetricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
        if (metricDataQueries == null) {
            this.metricDataQueries = null;
            return;
        }
        this.metricDataQueries = new ArrayList<MetricDataQuery>(metricDataQueries);
    }

    public ServiceLevelIndicatorMetric withMetricDataQueries(MetricDataQuery ... metricDataQueries) {
        if (this.metricDataQueries == null) {
            this.setMetricDataQueries(new ArrayList<MetricDataQuery>(metricDataQueries.length));
        }
        for (MetricDataQuery ele : metricDataQueries) {
            this.metricDataQueries.add(ele);
        }
        return this;
    }

    public ServiceLevelIndicatorMetric withMetricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
        this.setMetricDataQueries(metricDataQueries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyAttributes() != null) {
            sb.append("KeyAttributes: ").append(this.getKeyAttributes()).append(",");
        }
        if (this.getOperationName() != null) {
            sb.append("OperationName: ").append(this.getOperationName()).append(",");
        }
        if (this.getMetricType() != null) {
            sb.append("MetricType: ").append(this.getMetricType()).append(",");
        }
        if (this.getMetricDataQueries() != null) {
            sb.append("MetricDataQueries: ").append(this.getMetricDataQueries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelIndicatorMetric)) {
            return false;
        }
        ServiceLevelIndicatorMetric other = (ServiceLevelIndicatorMetric)obj;
        if (other.getKeyAttributes() == null ^ this.getKeyAttributes() == null) {
            return false;
        }
        if (other.getKeyAttributes() != null && !other.getKeyAttributes().equals(this.getKeyAttributes())) {
            return false;
        }
        if (other.getOperationName() == null ^ this.getOperationName() == null) {
            return false;
        }
        if (other.getOperationName() != null && !other.getOperationName().equals(this.getOperationName())) {
            return false;
        }
        if (other.getMetricType() == null ^ this.getMetricType() == null) {
            return false;
        }
        if (other.getMetricType() != null && !other.getMetricType().equals(this.getMetricType())) {
            return false;
        }
        if (other.getMetricDataQueries() == null ^ this.getMetricDataQueries() == null) {
            return false;
        }
        return other.getMetricDataQueries() == null || other.getMetricDataQueries().equals(this.getMetricDataQueries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyAttributes() == null ? 0 : this.getKeyAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getOperationName() == null ? 0 : this.getOperationName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricType() == null ? 0 : this.getMetricType().hashCode());
        hashCode = 31 * hashCode + (this.getMetricDataQueries() == null ? 0 : this.getMetricDataQueries().hashCode());
        return hashCode;
    }

    public ServiceLevelIndicatorMetric clone() {
        try {
            return (ServiceLevelIndicatorMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceLevelIndicatorMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

