/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.ApiConfiguration;

@SdkInternalApi
public class ApiConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> GRAPHQLCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("graphQLConfig").build();
    private static final MarshallingInfo<StructuredPojo> DATASTORECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataStoreConfig").build();
    private static final MarshallingInfo<StructuredPojo> NOAPICONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("noApiConfig").build();
    private static final ApiConfigurationMarshaller instance = new ApiConfigurationMarshaller();

    public static ApiConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ApiConfiguration apiConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (apiConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)apiConfiguration.getGraphQLConfig(), GRAPHQLCONFIG_BINDING);
            protocolMarshaller.marshall((Object)apiConfiguration.getDataStoreConfig(), DATASTORECONFIG_BINDING);
            protocolMarshaller.marshall((Object)apiConfiguration.getNoApiConfig(), NOAPICONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

