/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.CachingTransformerBuilder;
import com.agilejava.docbkx.maven.ExpressionHandler;
import com.agilejava.docbkx.maven.InjectingEntityResolver;
import com.agilejava.docbkx.maven.NullWriter;
import com.agilejava.docbkx.maven.Parameter;
import com.agilejava.docbkx.maven.PreprocessingFilter;
import com.agilejava.docbkx.maven.StylesheetResolver;
import com.agilejava.docbkx.maven.TransformerBuilder;
import com.icl.saxon.Controller;
import com.icl.saxon.TransformerFactoryImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.ValidityException;
import nu.xom.xinclude.XIncludeException;
import nu.xom.xinclude.XIncluder;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.antrun.AntPropertyHelper;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.types.Path;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractTransformerMojo
extends AbstractMojo {
    protected String[] catalogs = new String[]{"catalog.xml", "docbook/catalog.xml"};
    private Properties originalSystemProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.preProcess();
        File targetDirectory = this.getTargetDirectory();
        File sourceDirectory = this.getSourceDirectory();
        if (!sourceDirectory.exists()) {
            return;
        }
        if (!targetDirectory.exists()) {
            FileUtils.mkdir((String)targetDirectory.getAbsolutePath());
        }
        String[] included = this.scanIncludedFiles();
        CatalogManager catalogManager = this.createCatalogManager();
        CatalogResolver catalogResolver = new CatalogResolver(catalogManager);
        URIResolver uriResolver = this.createStyleSheetResolver(catalogResolver);
        InjectingEntityResolver injectingResolver = this.createEntityResolver((EntityResolver)catalogResolver);
        Object resolver = catalogResolver;
        if (injectingResolver != null) {
            resolver = injectingResolver;
        }
        TransformerBuilder builder = this.createTransformerBuilder(uriResolver);
        SAXParserFactory factory = this.createParserFactory();
        for (int i = included.length - 1; i >= 0; --i) {
            try {
                if (injectingResolver != null) {
                    injectingResolver.forceInjection();
                }
                String inputFilename = included[i];
                String baseTargetFile = inputFilename.substring(0, inputFilename.length() - 4);
                String targetFilename = baseTargetFile + "." + this.getTargetFileExtension();
                File sourceFile = new File(sourceDirectory, inputFilename);
                this.getLog().debug((CharSequence)("SourceFile: " + sourceFile.toString()));
                File targetFile = null;
                if (this.isUseStandardOutput()) {
                    targetFile = new File(targetDirectory, targetFilename);
                    this.getLog().debug((CharSequence)("TargetFile: " + targetFile.toString()));
                } else {
                    String name = new File(baseTargetFile).getName();
                    String dir = new File(baseTargetFile).getParent();
                    targetFile = dir == null ? targetDirectory : new File(targetDirectory, dir);
                    targetFile = new File(targetFile, name + "." + this.getTargetFileExtension());
                    this.getLog().debug((CharSequence)("TargetDirectory: " + targetDirectory.getAbsolutePath()));
                }
                if (!targetFile.exists() || targetFile.exists() && org.apache.commons.io.FileUtils.isFileNewer((File)sourceFile, (File)targetFile) || targetFile.exists() && this.getXIncludeSupported()) {
                    this.getLog().info((CharSequence)("Processing input file: " + inputFilename));
                    XMLReader reader = factory.newSAXParser().getXMLReader();
                    reader.setEntityResolver((EntityResolver)resolver);
                    PreprocessingFilter filter = this.createPIHandler((EntityResolver)resolver, reader);
                    Source xmlSource = this.createSource(inputFilename, sourceFile, filter);
                    this.configureXref(targetFile);
                    Transformer transformer = builder.build();
                    this.adjustTransformer(transformer, sourceFile.getAbsolutePath(), targetFile);
                    StreamResult result = null;
                    result = !this.shouldProcessResult() ? (this.getLog().isDebugEnabled() ? new StreamResult(System.out) : new StreamResult(new NullOutputStream())) : (this.isUseStandardOutput() ? new StreamResult(targetFile.getAbsolutePath()) : (this.getLog().isDebugEnabled() ? new StreamResult(System.out) : new StreamResult(new NullOutputStream())));
                    transformer.transform(xmlSource, result);
                    if (this.shouldProcessResult()) {
                        this.postProcessResult(targetFile);
                        if (this.isUseStandardOutput()) {
                            this.getLog().info((CharSequence)(targetFile + " has been generated."));
                            continue;
                        }
                        this.getLog().info((CharSequence)("See " + targetFile.getParentFile().getAbsolutePath() + " for generated file(s)"));
                        continue;
                    }
                    this.getLog().info((CharSequence)("See " + targetFile.getParentFile().getAbsolutePath() + " for generated secondary file(s)"));
                    continue;
                }
                this.getLog().info((CharSequence)(targetFile + " is up to date."));
                continue;
            }
            catch (SAXException saxe) {
                throw new MojoExecutionException("Failed to parse " + included[i] + ".", (Exception)saxe);
            }
            catch (TransformerException te) {
                throw new MojoExecutionException("Failed to transform " + included[i] + ".", (Exception)te);
            }
            catch (ParserConfigurationException pce) {
                throw new MojoExecutionException("Failed to construct parser.", (Exception)pce);
            }
        }
        this.postProcess();
    }

    protected boolean shouldProcessResult() {
        String collectXrefTargets = this.getProperty("collectXrefTargets");
        if (collectXrefTargets == null) {
            return true;
        }
        return !"only".equalsIgnoreCase(collectXrefTargets);
    }

    protected Source createSource(String inputFilename, File sourceFile, PreprocessingFilter filter) throws MojoExecutionException {
        if (this.getXIncludeSupported() && this.getGeneratedSourceDirectory() != null) {
            this.getLog().debug((CharSequence)"Advanced XInclude mode entered");
            Builder xomBuilder = new Builder();
            try {
                Document doc = xomBuilder.build(sourceFile);
                XIncluder.resolveInPlace((Document)doc);
                File dump = this.dumpResolvedXML(inputFilename, doc);
                return new SAXSource(filter, new InputSource(dump.getAbsolutePath()));
            }
            catch (ValidityException e) {
                throw new MojoExecutionException("Failed to validate source", (Exception)((Object)e));
            }
            catch (ParsingException e) {
                throw new MojoExecutionException("Failed to parse source", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read source", (Exception)e);
            }
            catch (XIncludeException e) {
                throw new MojoExecutionException("Failed to process XInclude", (Exception)((Object)e));
            }
        }
        this.getLog().debug((CharSequence)"Xerces XInclude mode entered");
        InputSource inputSource = new InputSource(sourceFile.getAbsolutePath());
        return new SAXSource(filter, inputSource);
    }

    private PreprocessingFilter createPIHandler(EntityResolver resolver, XMLReader reader) {
        PreprocessingFilter filter = new PreprocessingFilter(reader);
        ExpressionHandler resolvingHandler = new ExpressionHandler(new VariableResolver(){

            public Object resolveVariable(String name) throws ELException {
                if ("date".equals(name)) {
                    return DateFormat.getDateInstance(1).format(new Date());
                }
                if ("project".equals(name)) {
                    return AbstractTransformerMojo.this.getMavenProject();
                }
                return AbstractTransformerMojo.this.getMavenProject().getProperties().get(name);
            }
        }, this.getLog());
        filter.setHandlers(Arrays.asList(resolvingHandler));
        filter.setEntityResolver(resolver);
        return filter;
    }

    private InjectingEntityResolver createEntityResolver(EntityResolver resolver) {
        if (this.getEntities() != null) {
            return new InjectingEntityResolver(this.getEntities(), resolver, this.getType(), this.getLog());
        }
        return null;
    }

    private URIResolver createStyleSheetResolver(CatalogResolver catalogResolver) throws MojoExecutionException {
        StylesheetResolver uriResolver;
        try {
            URL url = this.getNonDefaultStylesheetURL() == null ? this.getDefaultStylesheetURL() : this.getNonDefaultStylesheetURL();
            this.getLog().debug((CharSequence)("Using stylesheet: " + url.toExternalForm()));
            uriResolver = new StylesheetResolver("urn:docbkx:stylesheet", new StreamSource(url.openStream(), url.toExternalForm()), (URIResolver)catalogResolver);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to read stylesheet.", (Exception)ioe);
        }
        return uriResolver;
    }

    private String[] scanIncludedFiles() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.getSourceDirectory());
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    protected File dumpResolvedXML(String initialFilename, Document doc) throws MojoExecutionException {
        File file = new File(initialFilename);
        String parent = file.getParent();
        File resolvedXML = null;
        if (parent != null) {
            resolvedXML = new File(this.getGeneratedSourceDirectory(), parent);
            resolvedXML.mkdirs();
            resolvedXML = new File(resolvedXML, "(gen)" + file.getName());
        } else {
            this.getGeneratedSourceDirectory().mkdirs();
            resolvedXML = new File(this.getGeneratedSourceDirectory(), "(gen)" + initialFilename);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(resolvedXML);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Failed to open dump file", (Exception)e);
        }
        if (fos != null) {
            this.getLog().info((CharSequence)("Dumping to " + resolvedXML.getAbsolutePath()));
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            Serializer serializer = new Serializer((OutputStream)bos);
            try {
                serializer.write(doc);
                bos.flush();
                bos.close();
                fos.close();
                File file2 = resolvedXML;
                return file2;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write to dump file", (Exception)e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)bos);
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
        throw new MojoExecutionException("Failed to open dump file");
    }

    private SAXParserFactory createParserFactory() {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        factory.setXIncludeAware(this.getXIncludeSupported());
        return factory;
    }

    protected abstract boolean getXIncludeSupported();

    protected abstract File getGeneratedSourceDirectory();

    protected String getNonDefaultStylesheetLocation() {
        return null;
    }

    protected abstract boolean isUseStandardOutput();

    abstract void setUseStandardOutput(boolean var1);

    protected abstract boolean isShowXslMessages();

    protected abstract void setShowXslMessages(boolean var1);

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
    }

    public void preProcess() throws MojoExecutionException {
        this.originalSystemProperties = (Properties)System.getProperties().clone();
        if (this.getSystemProperties() != null) {
            Enumeration<Object> props = this.getSystemProperties().keys();
            while (props.hasMoreElements()) {
                String key = (String)props.nextElement();
                System.setProperty(key, this.getSystemProperties().getProperty(key));
            }
        }
        if (this.getPreProcess() != null) {
            this.executeTasks(this.getPreProcess(), this.getMavenProject());
        }
    }

    public void postProcess() throws MojoExecutionException {
        if (this.getPostProcess() != null) {
            this.executeTasks(this.getPostProcess(), this.getMavenProject());
        }
        if (this.originalSystemProperties != null) {
            System.setProperties(this.originalSystemProperties);
        }
    }

    public void postProcessResult(File result) throws MojoExecutionException {
    }

    public void configureXref(File result) throws MojoExecutionException {
        File targetXrefFile = new File(result.getParentFile(), result.getName() + ".target.db");
        this.setProperty("targetsFilename", targetXrefFile.getAbsolutePath());
    }

    protected CatalogManager createCatalogManager() {
        CatalogManager manager = new CatalogManager();
        manager.setIgnoreMissingProperties(true);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        StringBuffer builder = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.catalogs.length; ++i) {
            String catalog = this.catalogs[i];
            try {
                Enumeration<URL> enumeration = classLoader.getResources(catalog);
                while (enumeration.hasMoreElements()) {
                    if (!first) {
                        builder.append(';');
                    } else {
                        first = false;
                    }
                    URL resource = enumeration.nextElement();
                    builder.append(resource.toExternalForm());
                }
                continue;
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)("Failed to search for catalog files: " + catalog));
            }
        }
        String catalogFiles = builder.toString();
        if (catalogFiles.length() == 0) {
            this.getLog().warn((CharSequence)"Failed to find catalog files.");
        } else {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Catalogs to load: " + catalogFiles));
            }
            manager.setCatalogFiles(catalogFiles);
        }
        return manager;
    }

    protected DocumentBuilder createDocumentBuilder() throws MojoExecutionException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (ParserConfigurationException pce) {
            throw new MojoExecutionException("Failed to construct parser.", (Exception)pce);
        }
    }

    protected XPath createTitleXPath() throws MojoExecutionException {
        try {
            StringBuffer builder = new StringBuffer();
            builder.append("(article/title|article/articleinfo/title|book/title|book/bookinfo/title)[position()=1]");
            return new DOMXPath(builder.toString());
        }
        catch (JaxenException je) {
            throw new MojoExecutionException("Failed to parse XPath.", (Exception)((Object)je));
        }
    }

    protected TransformerBuilder createTransformerBuilder(URIResolver resolver) {
        return new CachingTransformerBuilder(new DefaultTransformerBuilder(resolver));
    }

    private String getTitle(org.w3c.dom.Document document) throws MojoExecutionException {
        try {
            XPath titleXPath = this.createTitleXPath();
            Node titleNode = (Node)titleXPath.selectSingleNode((Object)document);
            if (titleNode != null) {
                return titleNode.getNodeValue();
            }
            return null;
        }
        catch (JaxenException je) {
            this.getLog().debug((CharSequence)"Failed to find title of document.");
            return null;
        }
    }

    protected void executeTasks(Target antTasks, MavenProject mavenProject) throws MojoExecutionException {
        try {
            ExpressionEvaluator exprEvaluator = (ExpressionEvaluator)antTasks.getProject().getReference("maven.expressionEvaluator");
            Project antProject = antTasks.getProject();
            PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)antProject);
            propertyHelper.setNext((PropertyHelper)new AntPropertyHelper(exprEvaluator, this.getLog()));
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setOutputPrintStream(System.out);
            antLogger.setErrorPrintStream(System.err);
            antLogger.setMessageOutputLevel(2);
            antProject.addBuildListener((BuildListener)antLogger);
            antProject.setBaseDir(mavenProject.getBasedir());
            Path p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getArtifacts().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.dependency.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.compile.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.runtime.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getTestClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.test.classpath", (Object)p);
            List artifacts = this.getArtifacts();
            ArrayList<String> list = new ArrayList<String>(artifacts.size());
            Iterator i = artifacts.iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                File file = a.getFile();
                if (file == null) {
                    throw new DependencyResolutionRequiredException(a);
                }
                list.add(file.getPath());
            }
            p = new Path(antProject);
            p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.plugin.classpath", (Object)p);
            this.getLog().info((CharSequence)"Executing tasks");
            antTasks.execute();
            this.getLog().info((CharSequence)"Executed tasks");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing ant tasks", e);
        }
    }

    protected abstract void configure(Transformer var1);

    protected abstract File getTargetDirectory();

    protected abstract File getSourceDirectory();

    protected abstract String[] getIncludes();

    protected URL getStylesheetURL() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.getStylesheetLocation());
        if (url == null) {
            try {
                if (this.getStylesheetLocation().startsWith("http://")) {
                    return new URL(this.getStylesheetLocation());
                }
                return new File(this.getStylesheetLocation()).toURL();
            }
            catch (MalformedURLException mue) {
                return null;
            }
        }
        return url;
    }

    protected URL getNonDefaultStylesheetURL() {
        if (this.getNonDefaultStylesheetLocation() != null) {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.getNonDefaultStylesheetLocation());
            return url;
        }
        return null;
    }

    protected URL getDefaultStylesheetURL() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.getDefaultStylesheetLocation());
        return url;
    }

    protected abstract String getDefaultStylesheetLocation();

    protected abstract String getStylesheetLocation();

    protected abstract String getTargetFileExtension();

    protected abstract void setTargetFileExtension(String var1);

    protected abstract List getEntities();

    protected abstract List getCustomizationParameters();

    protected abstract Properties getSystemProperties();

    protected abstract Target getPreProcess();

    protected abstract Target getPostProcess();

    protected abstract MavenProject getMavenProject();

    protected abstract List getArtifacts();

    protected abstract String getType();

    protected abstract boolean isSkip();

    protected Object convertStringToXsltParam(String value) {
        return value;
    }

    protected Object convertBooleanToXsltParam(String value) {
        String trimmed = value.trim();
        if ("false".equalsIgnoreCase(trimmed) || "0".equals(trimmed) || "no".equalsIgnoreCase(trimmed)) {
            return "0";
        }
        return "1";
    }

    protected void setProperty(String propertyname, String value) {
        try {
            Field f = ((Object)((Object)this)).getClass().getDeclaredField(propertyname);
            if (f.getType().equals(Boolean.class)) {
                f.set((Object)this, this.convertBooleanToXsltParam(value));
            } else {
                f.set((Object)this, value);
            }
        }
        catch (NoSuchFieldException e) {
            this.getLog().warn((CharSequence)("Property not found in " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.getLog().warn((CharSequence)("Unable to set " + propertyname + " value"), (Throwable)e);
        }
    }

    protected String getProperty(String propertyname) {
        try {
            Field f = ((Object)((Object)this)).getClass().getDeclaredField(propertyname);
            Object o = f.get((Object)this);
            if (o == null) {
                return null;
            }
            return o.toString();
        }
        catch (NoSuchFieldException e) {
            this.getLog().warn((CharSequence)("Property not found in " + ((Object)((Object)this)).getClass().getName()));
        }
        catch (IllegalAccessException e) {
            this.getLog().warn((CharSequence)("Unable to get " + propertyname + " value"));
        }
        return null;
    }

    private class DefaultTransformerBuilder
    implements TransformerBuilder {
        private URIResolver resolver;

        public DefaultTransformerBuilder(URIResolver resolver) {
            this.resolver = resolver;
        }

        public Transformer build() throws TransformerBuilder.TransformerBuilderException {
            Transformer transformer = this.createTransformer(this.resolver);
            transformer.setURIResolver(this.resolver);
            return transformer;
        }

        protected Transformer createTransformer(URIResolver uriResolver) throws TransformerBuilder.TransformerBuilderException {
            URL url = AbstractTransformerMojo.this.getStylesheetURL();
            try {
                TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
                transformerFactory.setURIResolver(uriResolver);
                StreamSource source = new StreamSource(url.openStream(), url.toExternalForm());
                Transformer transformer = transformerFactory.newTransformer(source);
                if (!AbstractTransformerMojo.this.isShowXslMessages()) {
                    Controller controller = (Controller)transformer;
                    try {
                        controller.makeMessageEmitter();
                        controller.getMessageEmitter().setWriter((Writer)new NullWriter());
                    }
                    catch (TransformerException te) {
                        AbstractTransformerMojo.this.getLog().error((CharSequence)"Failed to redirect xsl:message output.", (Throwable)te);
                    }
                }
                AbstractTransformerMojo.this.configure(transformer);
                if (AbstractTransformerMojo.this.getCustomizationParameters() != null) {
                    AbstractTransformerMojo.this.getLog().info((CharSequence)"Applying customization parameters after docbkx parameters");
                    Iterator iterator = AbstractTransformerMojo.this.getCustomizationParameters().iterator();
                    while (iterator.hasNext()) {
                        Parameter param = (Parameter)iterator.next();
                        if (param.getName() == null) continue;
                        transformer.setParameter(param.getName(), param.getValue());
                    }
                }
                return transformer;
            }
            catch (IOException ioe) {
                throw new TransformerBuilder.TransformerBuilderException("Failed to read stylesheet from " + url.toExternalForm(), ioe);
            }
            catch (TransformerConfigurationException tce) {
                throw new TransformerBuilder.TransformerBuilderException("Failed to build Transformer from " + url.toExternalForm(), tce);
            }
        }
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }
}

