/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.Type;
import co.paralleluniverse.asm.tree.MethodInsnNode;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.RuntimeSuspendExecution;
import co.paralleluniverse.fibers.Stack;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.fibers.instrument.DontInstrument;
import co.paralleluniverse.strands.Strand;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Classes {
    static final String THROWABLE_NAME = Throwable.class.getName().replace('.', '/');
    static final String EXCEPTION_NAME = Exception.class.getName().replace('.', '/');
    static final String RUNTIME_EXCEPTION_NAME = RuntimeException.class.getName().replace('.', '/');
    static final String SUSPEND_EXECUTION_NAME = SuspendExecution.class.getName().replace('.', '/');
    static final String RUNTIME_SUSPEND_EXECUTION_NAME = RuntimeSuspendExecution.class.getName().replace('.', '/');
    static final String UNDECLARED_THROWABLE_NAME = UndeclaredThrowableException.class.getName().replace('.', '/');
    static final String FIBER_CLASS_NAME = Fiber.class.getName().replace('.', '/');
    private static final String STRAND_NAME = Strand.class.getName().replace('.', '/');
    static final String STACK_NAME = Stack.class.getName().replace('.', '/');
    private static final BlockingMethod[] BLOCKING_METHODS = new BlockingMethod[]{new BlockingMethod("java/lang/Thread", "sleep", new String[]{"(J)V", "(JI)V"}), new BlockingMethod("java/lang/Thread", "join", new String[]{"()V", "(J)V", "(JI)V"}), new BlockingMethod("java/lang/Object", "wait", new String[]{"()V", "(J)V", "(JI)V"})};
    static final String SUSPENDABLE_DESC = Type.getDescriptor(Suspendable.class);
    static final String DONT_INSTRUMENT_DESC = Type.getDescriptor(DontInstrument.class);
    static final String INSTRUMENTED_DESC = Type.getDescriptor(Instrumented.class);
    static final String LAMBDA_METHOD_PREFIX = "lambda$";
    private static final Set<String> yieldMethods = new HashSet<String>(Arrays.asList("park", "yield", "parkAndUnpark", "yieldAndUnpark", "parkAndSerialize"));

    static boolean isYieldMethod(String className, String methodName) {
        return FIBER_CLASS_NAME.equals(className) && yieldMethods.contains(methodName);
    }

    static boolean isAllowedToBlock(String className, String methodName) {
        return STRAND_NAME.equals(className);
    }

    static int blockingCallIdx(MethodInsnNode ins) {
        int n = BLOCKING_METHODS.length;
        for (int i = 0; i < n; ++i) {
            if (!BLOCKING_METHODS[i].match(ins)) continue;
            return i;
        }
        return -1;
    }

    static int[] toIntArray(List<Integer> suspOffsetsAfterInstrL) {
        if (suspOffsetsAfterInstrL == null) {
            return null;
        }
        ArrayList<Integer> suspOffsetsAfterInstrLFiltered = new ArrayList<Integer>(suspOffsetsAfterInstrL.size());
        for (Integer i : suspOffsetsAfterInstrL) {
            if (i == null) continue;
            suspOffsetsAfterInstrLFiltered.add(i);
        }
        int[] ret = new int[suspOffsetsAfterInstrLFiltered.size()];
        int j = 0;
        for (Integer i : suspOffsetsAfterInstrLFiltered) {
            ret[j] = i;
            ++j;
        }
        return ret;
    }

    private Classes() {
    }

    private static class BlockingMethod {
        private final String owner;
        private final String name;
        private final String[] descs;

        private BlockingMethod(String owner, String name, String ... descs) {
            this.owner = owner;
            this.name = name;
            this.descs = descs;
        }

        boolean match(MethodInsnNode min) {
            if (this.owner.equals(min.owner) && this.name.equals(min.name)) {
                for (String desc : this.descs) {
                    if (!desc.equals(min.desc)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

