/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.forkjoin;

import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.monitoring.FlightRecorderMessage;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.common.util.SystemProperties;
import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.concurrent.forkjoin.ExtendedForkJoinWorkerThread;
import co.paralleluniverse.concurrent.util.ThreadAccess;
import co.paralleluniverse.fibers.Fiber;
import jsr166e.ForkJoinPool;
import jsr166e.ForkJoinTask;
import jsr166e.ForkJoinWorkerThread;
import sun.misc.Unsafe;

public abstract class ParkableForkJoinTask<V>
extends ForkJoinTask<V> {
    public static final FlightRecorder RECORDER = Debug.isDebug() ? Debug.getGlobalFlightRecorder() : null;
    public static final boolean CAPTURE_UNPARK_STACK = Debug.isDebug() || SystemProperties.isEmptyOrTrue("co.paralleluniverse.fibers.captureUnparkStackTrace");
    public static final Object EMERGENCY_UNBLOCKER = new Object();
    public static final Park PARK = new Park();
    public static final int RUNNABLE = 0;
    public static final int LEASED = 1;
    public static final int PARKED = -1;
    public static final int PARKING = -2;
    private final DummyRunnable taskRef = new DummyRunnable(this);
    private volatile int state = 0;
    private Object blocker;
    private ParkableForkJoinTask enclosing;
    private boolean parkExclusive;
    private Object unparker;
    private StackTraceElement[] unparkStackTrace;
    private static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final long stateOffset;

    public static ParkableForkJoinTask<?> getCurrent() {
        Fiber f;
        ParkableForkJoinTask ct = ParkableForkJoinTask.getCurrent1();
        if (ct == null && Thread.currentThread() instanceof ForkJoinWorkerThread && (f = Fiber.currentFiber()) != null) {
            ct = (ParkableForkJoinTask)f.getTask();
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean exec() {
        Thread currentThread = Thread.currentThread();
        Object oldTarget = ParkableForkJoinTask.getTarget(currentThread);
        this.enclosing = ParkableForkJoinTask.fromTarget(oldTarget);
        this.parkExclusive = false;
        this.blocker = null;
        ParkableForkJoinTask.setCurrent(this);
        try {
            boolean bl = this.doExec();
            return bl;
        }
        finally {
            ParkableForkJoinTask.setTarget(currentThread, oldTarget);
        }
    }

    public final void fork1() {
        this.fork();
    }

    static void setCurrent(ParkableForkJoinTask<?> task) {
        ParkableForkJoinTask.setTarget(Thread.currentThread(), task != null ? task.taskRef : null);
    }

    static ParkableForkJoinTask<?> fromTarget(Object target) {
        if (target instanceof DummyRunnable) {
            return ((DummyRunnable)target).task;
        }
        return null;
    }

    static ParkableForkJoinTask<?> getCurrent1() {
        return ParkableForkJoinTask.fromTarget(ParkableForkJoinTask.getTarget(Thread.currentThread()));
    }

    public static void setTarget(Thread thread, Object target) {
        if (thread instanceof ExtendedForkJoinWorkerThread) {
            ((ExtendedForkJoinWorkerThread)thread).setTarget(target);
        } else {
            ThreadAccess.setTarget(thread, (Runnable)target);
        }
    }

    public static Object getTarget(Thread thread) {
        if (thread instanceof ExtendedForkJoinWorkerThread) {
            return ((ExtendedForkJoinWorkerThread)thread).getTarget();
        }
        return ThreadAccess.getTarget(thread);
    }

    boolean doExec() {
        try {
            this.onExec();
            boolean res = this.exec1();
            this.onCompletion(res);
            return res;
        }
        catch (Park park) {
            return false;
        }
        catch (Throwable t) {
            this.onException(t);
            return true;
        }
    }

    protected abstract boolean exec1();

    public Object getBlocker() {
        if (this.state != -1) {
            return null;
        }
        return this.blocker;
    }

    ParkableForkJoinTask getEnclosing() {
        return this.enclosing;
    }

    protected void onExec() {
        if (Debug.isDebug()) {
            ParkableForkJoinTask.record("doExec", "executing %s", this);
        }
    }

    protected void onCompletion(boolean res) {
        ParkableForkJoinTask.record("doExec", "done normally %s", this, res);
    }

    protected void onException(Throwable t) {
        ParkableForkJoinTask.record("doExec", "exception in %s - %s, %s", this, t, t.getStackTrace());
        throw Exceptions.rethrow(t);
    }

    protected void parking(boolean yield) {
        this.doPark(yield);
    }

    protected void onParked(boolean yield) {
        if (Debug.isDebug()) {
            ParkableForkJoinTask.record("doExec", "parked " + (yield ? "(yield)" : "(park)") + " %s", this);
        }
    }

    protected Object getUnparker() {
        return this.unparker;
    }

    protected StackTraceElement[] getUnparkStackTrace() {
        return this.unparkStackTrace;
    }

    protected void doPark(boolean yield) {
        if (yield) {
            this.submit();
        } else {
            int newState;
            int _state;
            block5: do {
                _state = this.getState();
                switch (_state) {
                    case -2: {
                        newState = -1;
                        break;
                    }
                    case 0: {
                        newState = 0;
                        break block5;
                    }
                    case 1: {
                        newState = 0;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Illegal task state (a fiber has no chance to enter `doPark` in anything else than `PARKED` or `RESTART`): " + _state));
                    }
                }
            } while (!this.compareAndSetState(_state, newState));
            if (newState == 0) {
                this.submit();
            }
        }
        this.onParked(yield);
    }

    protected void throwPark(boolean yield) throws Exception {
        throw PARK;
    }

    protected boolean park(Object blocker) throws Exception {
        return this.park(blocker, false);
    }

    protected boolean park(Object blocker, boolean exclusive) throws Exception {
        int newState;
        int _state;
        do {
            _state = this.getState();
            switch (_state) {
                case 1: {
                    newState = 0;
                    break;
                }
                case 0: {
                    newState = -2;
                    break;
                }
                case -2: 
                case -1: {
                    throw new AssertionError((Object)("Unexpected task state (fiber parking or parked has no chance to to call `park`): " + _state));
                }
                default: {
                    throw new AssertionError((Object)("Unknown task state: " + _state));
                }
            }
        } while (!this.compareAndSetState(_state, newState));
        if (Debug.isDebug()) {
            ParkableForkJoinTask.record("park", "current: %s - %s -> %s (blocker: %s)", this, _state, newState, blocker);
        }
        if (newState == -2) {
            this.blocker = blocker;
            this.parkExclusive = exclusive;
            this.parking(false);
            this.throwPark(false);
            return true;
        }
        return false;
    }

    public boolean unpark() {
        return this.unpark(null);
    }

    public boolean unpark(Object unblocker) {
        return this.unpark(null, unblocker);
    }

    public boolean unpark(ForkJoinPool fjPool, Object unblocker) {
        int newState;
        int _state;
        if (this.isDone()) {
            return false;
        }
        do {
            _state = this.getState();
            switch (_state) {
                case 0: {
                    newState = 1;
                    break;
                }
                case -1: {
                    if (this.parkExclusive & unblocker != this.blocker & unblocker != EMERGENCY_UNBLOCKER) {
                        return false;
                    }
                    newState = 0;
                    break;
                }
                case -2: {
                    newState = 0;
                    break;
                }
                case 1: {
                    if (Debug.isDebug()) {
                        ParkableForkJoinTask.record("unpark", "current: %s - %s. return.", this, _state);
                    }
                    return false;
                }
                default: {
                    throw new AssertionError((Object)("Unknown task state: " + _state));
                }
            }
        } while (!this.compareAndSetState(_state, newState));
        if (Debug.isDebug()) {
            ParkableForkJoinTask.record("unpark", "current: %s - %s -> %s", this, _state, newState);
        }
        if (newState == 0) {
            this.unparker = unblocker;
            if (CAPTURE_UNPARK_STACK) {
                this.unparkStackTrace = Thread.currentThread().getStackTrace();
            }
            if (_state != -2) {
                if (fjPool != null) {
                    this.submit(fjPool);
                } else {
                    this.submit();
                }
            }
        }
        return _state == -1 || _state == -2;
    }

    protected boolean tryUnpark(Object unblocker) {
        boolean res = this.compareAndSetState(-1, 0);
        return res;
    }

    protected void yield() throws Exception {
        this.parking(true);
        this.onParked(true);
        this.throwPark(true);
    }

    protected void submit() {
        assert (Thread.currentThread() instanceof ForkJoinWorkerThread);
        this.fork();
    }

    private void submit(ForkJoinPool fjPool) {
        if (ForkJoinTask.getPool() == fjPool) {
            this.fork();
        } else {
            fjPool.submit(this);
        }
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) {
        this.state = state;
    }

    boolean compareAndSetState(int expect, int update) {
        return UNSAFE.compareAndSwapInt(this, stateOffset, expect, update);
    }

    public String toString() {
        return "ParkableForkJoinTask@" + Integer.toHexString(System.identityHashCode(this));
    }

    protected boolean isRecording() {
        return RECORDER != null;
    }

    public static void record(String method, String format) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("ParkableForkJoinTask", method, format, null));
        }
    }

    public static void record(String method, String format, Object arg1) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("ParkableForkJoinTask", method, format, new Object[]{arg1}));
        }
    }

    public static void record(String method, String format, Object arg1, Object arg2) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("ParkableForkJoinTask", method, format, new Object[]{arg1, arg2}));
        }
    }

    public static void record(String method, String format, Object arg1, Object arg2, Object arg3) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("ParkableForkJoinTask", method, format, new Object[]{arg1, arg2, arg3}));
        }
    }

    public static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("ParkableForkJoinTask", method, format, new Object[]{arg1, arg2, arg3, arg4}));
        }
    }

    public static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("ParkableForkJoinTask", method, format, new Object[]{arg1, arg2, arg3, arg4, arg5}));
        }
    }

    static {
        try {
            stateOffset = UNSAFE.objectFieldOffset(ParkableForkJoinTask.class.getDeclaredField("state"));
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static final class DummyRunnable
    implements Runnable {
        final ParkableForkJoinTask task;

        public DummyRunnable(ParkableForkJoinTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            throw new RuntimeException("This method shouldn't be run. This object is a placeholder.");
        }
    }

    public static class Park
    extends Error {
        private Park() {
            super(null, null, false, false);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

