/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry.nacos.configuration;

import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.registry.nacos.NacosServerRegistry;
import cn.ponfee.scheduler.registry.nacos.NacosSupervisorRegistry;
import cn.ponfee.scheduler.registry.nacos.NacosWorkerRegistry;
import cn.ponfee.scheduler.registry.nacos.configuration.NacosProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={NacosServerRegistry.class})
public class NacosServerRegistryConfigure {

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @DependsOn(value={"currentSupervisor"})
    @ConditionalOnBean(value={Worker.class})
    public static class NacosWorkerRegistryConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public WorkerRegistry workerRegistry(@Value(value="${distributed.scheduler.namespace:}") String namespace, NacosProperties config) {
            return new NacosWorkerRegistry(namespace, config);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @DependsOn(value={"currentWorker"})
    @ConditionalOnBean(value={Supervisor.class})
    public static class NacosSupervisorRegistryConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SupervisorRegistry supervisorRegistry(@Value(value="${distributed.scheduler.namespace:}") String namespace, NacosProperties config) {
            return new NacosSupervisorRegistry(namespace, config);
        }
    }
}

