/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.dispatch.redis;

import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.common.spring.RedisKeyRenewal;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.dispatch.redis.RedisTaskDispatchingUtils;
import cn.ponfee.scheduler.registry.Discovery;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisTaskDispatcher
extends TaskDispatcher {
    private final Map<String, RedisKeyRenewal> workerRenewMap = new ConcurrentHashMap<String, RedisKeyRenewal>();
    private final RedisTemplate<String, String> redisTemplate;

    public RedisTaskDispatcher(Discovery<Worker> discoveryWorker, @Nullable TimingWheel<ExecuteParam> timingWheel, RedisTemplate<String, String> redisTemplate) {
        super(discoveryWorker, timingWheel);
        this.redisTemplate = redisTemplate;
    }

    protected final boolean dispatch(ExecuteParam executeParam) {
        Worker worker = executeParam.getWorker();
        String key = RedisTaskDispatchingUtils.buildDispatchTasksKey(worker);
        Long ret = (Long)this.redisTemplate.execute(conn -> conn.rPush(key.getBytes(), (byte[][])new byte[][]{executeParam.serialize()}));
        RedisKeyRenewal renewal = this.workerRenewMap.computeIfAbsent(key, k -> new RedisKeyRenewal(this.redisTemplate, key));
        renewal.renewIfNecessary();
        return ret != null && ret > 0L;
    }
}

