/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.dispatch.http.configuration;

import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.core.base.HttpProperties;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.dispatch.TaskReceiver;
import cn.ponfee.scheduler.dispatch.http.HttpTaskDispatcher;
import cn.ponfee.scheduler.dispatch.http.HttpTaskReceiver;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.registry.DiscoveryRestTemplate;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
public class HttpTaskDispatchingConfiguration {

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @DependsOn(value={"currentSupervisor"})
    @ConditionalOnBean(value={Worker.class})
    @ConditionalOnSingleCandidate(value=TimingWheel.class)
    public static class HttpTaskReceiverConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public TaskReceiver taskReceiver(TimingWheel<ExecuteParam> timingWheel) {
            return new HttpTaskReceiver(timingWheel);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @ConditionalOnClass(value={RestTemplate.class})
    @DependsOn(value={"currentWorker"})
    @ConditionalOnBean(value={Supervisor.class})
    public static class HttpTaskDispatcherConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public TaskDispatcher taskDispatcher(HttpProperties properties, SupervisorRegistry discoveryWorker, @Nullable TimingWheel<ExecuteParam> timingWheel, @Nullable @Qualifier(value="distributed.scheduler.object-mapper") ObjectMapper objectMapper) {
            DiscoveryRestTemplate discoveryRestTemplate = DiscoveryRestTemplate.builder().connectTimeout(properties.getConnectTimeout()).readTimeout(properties.getReadTimeout()).maxRetryTimes(properties.getMaxRetryTimes()).objectMapper(objectMapper != null ? objectMapper : Jsons.createObjectMapper((JsonInclude.Include)JsonInclude.Include.NON_NULL)).discoveryServer((Discovery)discoveryWorker).build();
            return new HttpTaskDispatcher((DiscoveryRestTemplate<Worker>)discoveryRestTemplate, timingWheel);
        }
    }
}

