/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ImplicitAction;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.EndEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.EventPlayer;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.spi.ContextAwareImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private static List EMPTY_LIST = new Vector(0);
    private final RuleStore ruleStore;
    private final InterpretationContext ec;
    private final ArrayList<ImplicitAction> implicitActions;
    private final ContextAwareImpl cai = new ContextAwareImpl(this);
    Pattern pattern;
    Locator locator;
    EventPlayer player;
    Stack<List> actionListStack;
    Pattern skip = null;

    public Interpreter(Context context, RuleStore rs) {
        this.cai.setContext(context);
        this.ruleStore = rs;
        this.ec = new InterpretationContext(context, this);
        this.implicitActions = new ArrayList(3);
        this.pattern = new Pattern();
        this.actionListStack = new Stack();
        this.player = new EventPlayer(this);
    }

    public InterpretationContext getExecutionContext() {
        return this.ec;
    }

    public void startDocument() {
    }

    public void startElement(StartEvent se) {
        this.setDocumentLocator(se.getLocator());
        this.startElement(se.namespaceURI, se.localName, se.qName, se.attributes);
    }

    private void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        String tagName = this.getTagName(localName, qName);
        this.pattern.push(tagName);
        List applicableActionList = this.getApplicableActionList(this.pattern, atts);
        if (applicableActionList != null) {
            this.actionListStack.add(applicableActionList);
            this.callBeginAction(applicableActionList, tagName, atts);
        } else {
            this.actionListStack.add(EMPTY_LIST);
            String errMsg = "no applicable action for [" + tagName + "], current pattern is [" + this.pattern + "]";
            this.cai.addError(errMsg);
        }
    }

    public void characters(BodyEvent be) {
        this.setDocumentLocator(be.locator);
        String body = be.getText();
        List applicableActionList = this.actionListStack.peek();
        if (body != null) {
            body = body.trim();
        }
        if (body.length() > 0) {
            this.callBodyAction(applicableActionList, body);
        }
    }

    public void endElement(EndEvent endEvent) {
        this.setDocumentLocator(endEvent.locator);
        this.endElement(endEvent.namespaceURI, endEvent.localName, endEvent.qName);
    }

    private void endElement(String namespaceURI, String localName, String qName) {
        List applicableActionList = this.actionListStack.pop();
        if (this.skip != null) {
            if (this.skip.equals(this.pattern)) {
                this.skip = null;
            }
        } else if (applicableActionList != EMPTY_LIST) {
            this.callEndAction(applicableActionList, this.getTagName(localName, qName));
        }
        this.pattern.pop();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    String getTagName(String localName, String qName) {
        String tagName = localName;
        if (tagName == null || tagName.length() < 1) {
            tagName = qName;
        }
        return tagName;
    }

    public void addImplicitAction(ImplicitAction ia) {
        this.implicitActions.add(ia);
    }

    List lookupImplicitAction(Pattern pattern, Attributes attributes, InterpretationContext ec) {
        int len = this.implicitActions.size();
        for (int i = 0; i < len; ++i) {
            ImplicitAction ia = this.implicitActions.get(i);
            if (!ia.isApplicable(pattern, attributes, ec)) continue;
            ArrayList<ImplicitAction> actionList = new ArrayList<ImplicitAction>(1);
            actionList.add(ia);
            return actionList;
        }
        return null;
    }

    List getApplicableActionList(Pattern pattern, Attributes attributes) {
        List applicableActionList = this.ruleStore.matchActions(pattern);
        if (applicableActionList == null) {
            applicableActionList = this.lookupImplicitAction(pattern, attributes, this.ec);
        }
        return applicableActionList;
    }

    void callBeginAction(List applicableActionList, String tagName, Attributes atts) {
        if (applicableActionList == null) {
            return;
        }
        if (this.skip != null) {
            return;
        }
        for (Action action : applicableActionList) {
            try {
                action.begin(this.ec, tagName, atts);
            }
            catch (ActionException ae) {
                switch (ae.getSkipCode()) {
                    case 1: {
                        this.skip = (Pattern)this.pattern.clone();
                        break;
                    }
                    case 2: {
                        this.skip = (Pattern)this.pattern.clone();
                        this.skip.pop();
                    }
                }
            }
            catch (Exception e) {
                this.skip = (Pattern)this.pattern.clone();
                this.cai.addError("Exception in Action for tag [" + tagName + "]", e);
            }
        }
    }

    private void callBodyAction(List applicableActionList, String body) {
        if (applicableActionList == null) {
            return;
        }
        for (Action action : applicableActionList) {
            try {
                action.body(this.ec, body);
            }
            catch (ActionException ae) {
                this.cai.addError("Exception in end() methd for action [" + action + "]", ae);
            }
        }
    }

    private void callEndAction(List applicableActionList, String tagName) {
        if (applicableActionList == null) {
            return;
        }
        for (Action action : applicableActionList) {
            try {
                action.end(this.ec, tagName);
            }
            catch (ActionException ae) {
                switch (ae.getSkipCode()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.skip = (Pattern)this.pattern.clone();
                        this.skip.pop();
                    }
                }
            }
            catch (Exception e) {
                this.cai.addError("Exception in Action for tag [" + tagName + "]", e);
                this.skip = (Pattern)this.pattern.clone();
                this.skip.pop();
            }
        }
    }

    public RuleStore getRuleStore() {
        return this.ruleStore;
    }

    public void play(List<SaxEvent> eventList) {
        this.player.play(eventList);
    }

    public void addEvents(List<SaxEvent> eventList) {
        if (this.player != null) {
            this.player.addEvents(eventList);
        }
    }
}

