/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.StochasticProcess;

public class BrownianMotion
extends StochasticProcess {
    protected NormalGen gen;
    protected double mu;
    protected double sigma;
    protected double[] mudt;
    protected double[] sigmasqrdt;

    public BrownianMotion(double x0, double mu, double sigma, RandomStream stream) {
        this(x0, mu, sigma, new NormalGen(stream));
    }

    public BrownianMotion(double x0, double mu, double sigma, NormalGen gen) {
        this.mu = mu;
        this.sigma = sigma;
        this.x0 = x0;
        this.gen = gen;
    }

    @Override
    public double nextObservation() {
        double x = this.path[this.observationIndex];
        ++this.observationIndex;
        this.path[this.observationIndex] = x += this.mudt[this.observationIndex] + this.sigmasqrdt[this.observationIndex] * this.gen.nextDouble();
        return x;
    }

    public double nextObservation(double nextTime) {
        double x = this.path[this.observationIndex];
        double previousTime = this.t[this.observationIndex];
        ++this.observationIndex;
        this.t[this.observationIndex] = nextTime;
        double dt = nextTime - previousTime;
        this.path[this.observationIndex] = x += this.mu * dt + this.sigma * Math.sqrt(dt) * this.gen.nextDouble();
        return x;
    }

    public double nextObservation(double x, double dt) {
        return x += this.mu * dt + this.sigma * Math.sqrt(dt) * this.gen.nextDouble();
    }

    @Override
    public double[] generatePath() {
        double x = this.x0;
        for (int j = 0; j < this.d; ++j) {
            this.path[j + 1] = x += this.mudt[j] + this.sigmasqrdt[j] * this.gen.nextDouble();
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniform01) {
        double x = this.x0;
        for (int j = 0; j < this.d; ++j) {
            this.path[j + 1] = x += this.mudt[j] + this.sigmasqrdt[j] * NormalDist.inverseF01(uniform01[j]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    @Override
    public double[] generatePath(RandomStream stream) {
        this.gen.setStream(stream);
        return this.generatePath();
    }

    public void setParams(double x0, double mu, double sigma) {
        this.x0 = x0;
        this.mu = mu;
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.sigma = sigma;
        if (this.observationTimesSet) {
            this.init();
        }
    }

    @Override
    public void setStream(RandomStream stream) {
        this.gen.setStream(stream);
    }

    @Override
    public RandomStream getStream() {
        return this.gen.getStream();
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public NormalGen getGen() {
        return this.gen;
    }

    @Override
    protected void init() {
        super.init();
        this.mudt = new double[this.d];
        this.sigmasqrdt = new double[this.d];
        for (int j = 0; j < this.d; ++j) {
            double dt = this.t[j + 1] - this.t[j];
            this.mudt[j] = this.mu * dt;
            this.sigmasqrdt[j] = this.sigma * Math.sqrt(dt);
        }
    }
}

