/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.density;

import umontreal.ssj.stat.ScaledHistogram;
import umontreal.ssj.stat.TallyHistogram;
import umontreal.ssj.stat.density.DensityEstimator;

public class DEHistogram
extends DensityEstimator {
    private ScaledHistogram histDensity;

    public DEHistogram(double a, double b, int numBins) {
        this.histDensity = new ScaledHistogram(a, b, numBins);
    }

    public DEHistogram(double[] data, double a, double b, int numBins) {
        TallyHistogram tallyHist = new TallyHistogram(a, b, numBins);
        tallyHist.fillFromArray(data);
        this.histDensity = new ScaledHistogram(tallyHist, tallyHist.getProportionInBoundaries());
    }

    public DEHistogram(TallyHistogram tallyHist) {
        this.histDensity = new ScaledHistogram(tallyHist, tallyHist.getProportionInBoundaries());
    }

    public DEHistogram(ScaledHistogram scaledHist) {
        this.histDensity = scaledHist;
    }

    @Override
    public void setData(double[] data) {
        TallyHistogram tallyHist = new TallyHistogram(this.histDensity.getA(), this.histDensity.getB(), this.histDensity.getNumBins());
        tallyHist.fillFromArray(data);
        this.histDensity = new ScaledHistogram(tallyHist, tallyHist.getProportionInBoundaries());
    }

    public ScaledHistogram getScaledHistogram() {
        return this.histDensity;
    }

    public int getNumBins() {
        return this.histDensity.getNumBins();
    }

    public double getH() {
        return (this.getB() - this.getA()) / (double)this.getNumBins();
    }

    public double getA() {
        return this.histDensity.getA();
    }

    public double getB() {
        return this.histDensity.getB();
    }

    @Override
    public String toString() {
        return "Histogram estimator with " + this.getNumBins() + " bins.";
    }

    @Override
    public double evalDensity(double x) {
        return this.histDensity.getHeights()[(int)((x - this.getA()) / this.getH())];
    }

    @Override
    public double[] evalDensity(double[] evalPoints) {
        int k = evalPoints.length;
        double[] density = new double[k];
        for (int j = 0; j < k; ++j) {
            density[j] = this.histDensity.getHeights()[(int)((evalPoints[j] - this.getA()) / this.getH())];
        }
        return density;
    }

    public double[] evalDensity() {
        return this.histDensity.getHeights();
    }

    public void setH(double h) {
        int numBins = (int)((this.getB() - this.getA()) / h);
        TallyHistogram tallyHist = new TallyHistogram(this.histDensity.getA(), this.histDensity.getB(), numBins);
        tallyHist.fillFromArray(this.data);
        this.histDensity = new ScaledHistogram(tallyHist, tallyHist.getProportionInBoundaries());
    }

    public static double evalDensity(double x, double[] data, double a, double b, int numBins) {
        TallyHistogram tallyHist = new TallyHistogram(a, b, numBins);
        tallyHist.fillFromArray(data);
        return DEHistogram.evalDensity(x, tallyHist);
    }

    public static double[] evalDensity(double[] evalPoints, double[] data, double a, double b, int numBins) {
        TallyHistogram tallyHist = new TallyHistogram(a, b, numBins);
        tallyHist.fillFromArray(data);
        return DEHistogram.evalDensity(evalPoints, tallyHist);
    }

    public static double[] evalDensity(double[] data, double a, double b, int numBins) {
        TallyHistogram tallyHist = new TallyHistogram(a, b, numBins);
        tallyHist.fillFromArray(data);
        return DEHistogram.evalDensity(tallyHist);
    }

    public static double[][] evalDensity(double[][] data, double a, double b, int numBins) {
        int m = data.length;
        double[][] dens = new double[m][numBins];
        TallyHistogram tallyHist = new TallyHistogram(a, b, numBins);
        for (int r = 0; r < m; ++r) {
            tallyHist.fillFromArray(data[r]);
            dens[r] = DEHistogram.evalDensity(tallyHist);
        }
        return dens;
    }

    public static double[][] evalDensity(double[] evalPoints, double[][] data, double a, double b, int numBins) {
        int m = data.length;
        double[][] dens = new double[m][numBins];
        TallyHistogram tallyHist = new TallyHistogram(a, b, numBins);
        for (int r = 0; r < m; ++r) {
            tallyHist.fillFromArray(data[r]);
            dens[r] = DEHistogram.evalDensity(evalPoints, tallyHist);
        }
        return dens;
    }

    public static double evalDensity(double x, TallyHistogram tallyHist) {
        ScaledHistogram hist = new ScaledHistogram(tallyHist, tallyHist.getProportionInBoundaries());
        double h = (hist.getB() - hist.getA()) / (double)hist.getNumBins();
        return hist.getHeights()[(int)((x - hist.getA()) / h)];
    }

    public static double[] evalDensity(double[] evalPoints, TallyHistogram tallyHist) {
        ScaledHistogram hist = new ScaledHistogram(tallyHist, tallyHist.getProportionInBoundaries());
        int k = evalPoints.length;
        double[] density = new double[k];
        double h = (hist.getB() - hist.getA()) / (double)hist.getNumBins();
        for (int j = 0; j < k; ++j) {
            density[j] = hist.getHeights()[(int)((evalPoints[j] - hist.getA()) / h)];
        }
        return density;
    }

    public static double[] evalDensity(TallyHistogram tallyHist) {
        ScaledHistogram hist = new ScaledHistogram(tallyHist, tallyHist.getProportionInBoundaries());
        return hist.getHeights();
    }

    public static double[][] evalDensity(double[] evalPoints, TallyHistogram[] tallyHistArray) {
        int m = tallyHistArray.length;
        int k = evalPoints.length;
        double[][] density = new double[m][k];
        for (int r = 0; r < m; ++r) {
            density[r] = DEHistogram.evalDensity(evalPoints, tallyHistArray[r]);
        }
        return density;
    }

    public static double[][] evalDensity(TallyHistogram[] tallyHistArray) {
        int m = tallyHistArray.length;
        double[][] dens = new double[m][];
        for (int r = 0; r < m; ++r) {
            dens[r] = DEHistogram.evalDensity(tallyHistArray[r]);
        }
        return dens;
    }

    public static double evalDensity(double x, ScaledHistogram scaledHist) {
        double h = (scaledHist.getB() - scaledHist.getA()) / (double)scaledHist.getNumBins();
        return scaledHist.getHeights()[(int)((x - scaledHist.getA()) / h)];
    }

    public static double[] evalDensity(double[] evalPoints, ScaledHistogram scaledHist) {
        int k = evalPoints.length;
        double[] density = new double[k];
        double h = (scaledHist.getB() - scaledHist.getA()) / (double)scaledHist.getNumBins();
        for (int j = 0; j < k; ++j) {
            density[k] = scaledHist.getHeights()[(int)((evalPoints[j] - scaledHist.getA()) / h)];
        }
        return density;
    }

    public static double[] evalDensity(ScaledHistogram scaledHist) {
        return scaledHist.getHeights();
    }

    public static double[][] evalDensity(double[] evalPoints, ScaledHistogram[] scaledHistArray) {
        int m = scaledHistArray.length;
        double[][] density = new double[m][];
        for (int r = 0; r < m; ++r) {
            density[m] = DEHistogram.evalDensity(evalPoints, scaledHistArray[r]);
        }
        return density;
    }

    public static double[][] evalDensity(ScaledHistogram[] scaledHistArray) {
        int m = scaledHistArray.length;
        double[][] density = new double[m][];
        for (int r = 0; r < m; ++r) {
            density[r] = DEHistogram.evalDensity(scaledHistArray[r]);
        }
        return density;
    }
}

