/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.simevents;

import umontreal.ssj.simevents.Simulator;
import umontreal.ssj.stat.StatProbe;
import umontreal.ssj.util.PrintfFormat;

public class Accumulate
extends StatProbe
implements Cloneable {
    private double initTime;
    private double lastTime;
    private double lastValue;
    private Simulator sim;

    public Accumulate() {
        this.sim = Simulator.getDefaultSimulator();
        this.init();
    }

    public Accumulate(Simulator inSim) {
        if (inSim == null) {
            throw new NullPointerException();
        }
        this.sim = inSim;
        this.init();
    }

    public Accumulate(String name) {
        this.sim = Simulator.getDefaultSimulator();
        this.name = name;
        this.init();
    }

    public Accumulate(Simulator inSim, String name) {
        if (inSim == null) {
            throw new NullPointerException();
        }
        this.sim = inSim;
        this.name = name;
        this.init();
    }

    @Override
    public void init() {
        this.maxValue = Double.MIN_VALUE;
        this.minValue = Double.MAX_VALUE;
        this.lastValue = 0.0;
        this.sumValue = 0.0;
        this.initTime = this.lastTime = this.sim.time();
    }

    public void init(double x) {
        this.init();
        this.update(x);
    }

    public void update() {
        this.update(this.lastValue);
    }

    public void update(double x) {
        if (this.collect) {
            double time = this.sim.time();
            if (x < this.minValue) {
                this.minValue = x;
            }
            if (x > this.maxValue) {
                this.maxValue = x;
            }
            this.sumValue += this.lastValue * (time - this.lastTime);
            this.lastValue = x;
            this.lastTime = time;
        }
        if (this.broadcast) {
            this.notifyListeners(x);
        }
    }

    @Override
    public double sum() {
        this.update(this.lastValue);
        return this.sumValue;
    }

    @Override
    public double average() {
        this.update(this.lastValue);
        double periode = this.lastTime - this.initTime;
        if (periode > 0.0) {
            return this.sumValue / periode;
        }
        return 0.0;
    }

    @Override
    public String shortReportHeader() {
        PrintfFormat pf = new PrintfFormat();
        pf.append(-9, "from time").append("   ");
        pf.append(-9, "to time").append("   ");
        pf.append(-8, "   min").append("   ");
        pf.append(-8, "   max").append("   ");
        pf.append(-10, " average");
        return pf.toString();
    }

    @Override
    public String shortReport() {
        this.update();
        PrintfFormat pf = new PrintfFormat();
        pf.append(9, 2, 2, this.getInitTime()).append("   ");
        pf.append(9, 2, 2, this.getLastTime()).append("   ");
        pf.append(8, 3, 2, this.min()).append("   ");
        pf.append(8, 3, 2, this.max()).append("   ");
        pf.append(10, 3, 2, this.average());
        return pf.toString();
    }

    @Override
    public String report() {
        this.update(this.lastValue);
        PrintfFormat str = new PrintfFormat();
        str.append("REPORT on Accumulate stat. collector ==> " + this.name);
        str.append(PrintfFormat.NEWLINE + "      from time   to time       min         max");
        str.append("         average").append(PrintfFormat.NEWLINE);
        str.append(12, 2, 2, this.initTime);
        str.append(13, 2, 2, this.lastTime);
        str.append(11, 3, 2, this.minValue);
        str.append(12, 3, 2, this.maxValue);
        str.append(14, 3, 2, this.average()).append(PrintfFormat.NEWLINE);
        return str.toString();
    }

    public double getInitTime() {
        return this.initTime;
    }

    public double getLastTime() {
        return this.lastTime;
    }

    public double getLastValue() {
        return this.lastValue;
    }

    public Simulator simulator() {
        return this.sim;
    }

    public void setSimulator(Simulator sim) {
        if (sim == null) {
            throw new NullPointerException();
        }
        this.sim = sim;
    }

    @Override
    public Accumulate clone() {
        try {
            return (Accumulate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Accumulate can't clone");
        }
    }
}

