/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.GeometricDist;
import umontreal.ssj.probdist.PascalDist;
import umontreal.ssj.randvar.PascalGen;
import umontreal.ssj.rng.RandomStream;

public class PascalConvolutionGen
extends PascalGen {
    public PascalConvolutionGen(RandomStream s, int n, double p) {
        super(s, null);
        this.setParams(n, p);
    }

    public PascalConvolutionGen(RandomStream s, PascalDist dist) {
        super(s, dist);
    }

    @Override
    public int nextInt() {
        int x = 0;
        for (int i = 0; i < this.n; ++i) {
            x += GeometricDist.inverseF(this.p, this.stream.nextDouble());
        }
        return x;
    }

    public static int nextInt(RandomStream s, int n, double p) {
        return PascalConvolutionGen.convolution(s, n, p);
    }

    private static int convolution(RandomStream stream, int n, double p) {
        int x = 0;
        for (int i = 0; i < n; ++i) {
            x += GeometricDist.inverseF(p, stream.nextDouble());
        }
        return x;
    }
}

