/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class NormalGen
extends RandomVariateGen {
    protected double mu;
    protected double sigma = -1.0;

    public NormalGen(RandomStream s, double mu, double sigma) {
        super(s, new NormalDist(mu, sigma));
        this.setParams(mu, sigma);
    }

    public NormalGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public NormalGen(RandomStream s, NormalDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getSigma());
        }
    }

    public static double nextDouble(RandomStream s, double mu, double sigma) {
        return NormalDist.inverseF(mu, sigma, s.nextDouble());
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    protected void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = mu;
        this.sigma = sigma;
    }
}

