/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.latnetbuilder.weights;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import umontreal.ssj.latnetbuilder.weights.SingletonWeightComparable;
import umontreal.ssj.latnetbuilder.weights.WeightsComparable;

public class OrderDependentWeights
extends WeightsComparable<Integer> {
    protected String fileDir = "";
    protected String fileName = "";

    public OrderDependentWeights(ArrayList<SingletonWeightComparable<Integer>> weightList) {
        super(weightList);
    }

    public OrderDependentWeights() {
    }

    public void setFileDir(String dir) {
        this.fileDir = dir;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void write() throws IOException {
        FileWriter file = new FileWriter(this.fileDir + this.fileName);
        StringBuffer sb = new StringBuffer("");
        for (SingletonWeightComparable w : this.weights) {
            sb.append("order " + w.getIndex() + ":\t" + w.getWeight() + "\n");
        }
        sb.append("default:\t" + this.defaultWeight);
        file.write(sb.toString());
        file.close();
    }

    String printBody() {
        if (!this.sorted) {
            this.sort();
        }
        StringBuffer sb = new StringBuffer("");
        if (this.weights.size() > 0) {
            int index = 1;
            for (SingletonWeightComparable w : this.weights) {
                while (index < (Integer)w.getIndex()) {
                    sb.append(this.getDefaultWeight() + ",");
                    ++index;
                }
                sb.append(w.getWeight() + ",");
                ++index;
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append("Order dependent weights [default = " + this.getDefaultWeight() + "]:\n");
        if (this.weights.size() > 0) {
            sb.append("[");
        }
        sb.append(this.printBody());
        return sb.toString() + (this.weights.size() > 0 ? "]" : "");
    }

    @Override
    public String toLatNetBuilder() {
        StringBuffer sb = new StringBuffer("");
        sb.append("order-dependent:" + this.getDefaultWeight());
        if (this.weights.size() > 0) {
            sb.append(":");
        }
        sb.append(this.printBody());
        return sb.toString();
    }
}

