/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import umontreal.ssj.hups.DigitalNet;
import umontreal.ssj.util.PrintfFormat;

public class DigitalNetFromFile
extends DigitalNet {
    private String filename;

    private void readMatrices(StreamTokenizer st, int r, int k, int dim) throws IOException, NumberFormatException {
        this.genMat = new int[dim * k][r];
        for (int i = 0; i < dim; ++i) {
            for (int c = 0; c < k; ++c) {
                int j;
                for (j = 0; j < r; ++j) {
                    st.nextToken();
                    this.genMat[i * this.numCols + c][j] = (int)st.nval;
                }
                for (j = r; j < this.numRows; ++j) {
                    st.nextToken();
                }
            }
        }
    }

    void readData(StreamTokenizer st) throws IOException, NumberFormatException {
        st.eolIsSignificant(false);
        st.slashSlashComments(true);
        int i = st.nextToken();
        if (i != -2) {
            throw new NumberFormatException(" readData: cannot read base");
        }
        this.b = (int)st.nval;
        st.nextToken();
        this.numCols = (int)st.nval;
        st.nextToken();
        this.numRows = (int)st.nval;
        st.nextToken();
        this.numPoints = (int)st.nval;
        st.nextToken();
        this.dim = (int)st.nval;
        if (this.dim < 1) {
            throw new IllegalArgumentException(" dimension dim <= 0");
        }
    }

    static BufferedReader openURL(String filename) throws MalformedURLException, IOException {
        try {
            URL url = new URL(filename);
            BufferedReader input = new BufferedReader(new InputStreamReader(url.openStream()));
            return input;
        }
        catch (MalformedURLException e) {
            System.err.println(e + "   Invalid URL address:   " + filename);
            throw e;
        }
        catch (IOException e) {
            System.err.println(e + " in openURL with " + filename);
            throw e;
        }
    }

    static BufferedReader openFile(String filename) throws IOException {
        try {
            BufferedReader input;
            File f = new File(filename);
            if (f.exists()) {
                if (f.isDirectory()) {
                    throw new IOException(filename + " is a directory");
                }
                input = new BufferedReader(new FileReader(filename));
            } else {
                String pseudo = "umontreal/ssj/hups/data/";
                StringBuffer pathname = new StringBuffer(pseudo);
                for (int ci = 0; ci < filename.length(); ++ci) {
                    char ch = filename.charAt(ci);
                    if (ch == File.separatorChar) {
                        pathname.append('/');
                        continue;
                    }
                    pathname.append(ch);
                }
                InputStream dataInput = DigitalNetFromFile.class.getClassLoader().getResourceAsStream(pathname.toString());
                if (dataInput == null) {
                    throw new FileNotFoundException();
                }
                input = new BufferedReader(new InputStreamReader(dataInput));
            }
            return input;
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " *** cannot find  " + filename);
            throw e;
        }
        catch (IOException e) {
            System.err.println(e + " cannot read from  " + filename);
            throw e;
        }
    }

    public DigitalNetFromFile(String filename, int r1, int w, int s1) throws MalformedURLException, IOException {
        BufferedReader input = null;
        StreamTokenizer st = null;
        try {
            input = filename.startsWith("http:") || filename.startsWith("ftp:") ? DigitalNetFromFile.openURL(filename) : DigitalNetFromFile.openFile(filename);
            st = new StreamTokenizer(input);
            this.readData(st);
        }
        catch (MalformedURLException e) {
            System.err.println("   Invalid URL address:   " + filename);
            throw e;
        }
        catch (FileNotFoundException e) {
            System.err.println("   Cannot find  " + filename);
            throw e;
        }
        catch (NumberFormatException e) {
            System.err.println("   Cannot read number from " + filename);
            throw e;
        }
        catch (IOException e) {
            System.err.println("   IOException:   " + filename);
            throw e;
        }
        if (this.b == 2) {
            System.err.println("   base = 2, use DigitalNetBase2FromFile");
            throw new IllegalArgumentException("base = 2, use DigitalNetBase2FromFile");
        }
        if ((double)this.numCols * Math.log(this.b) > 31.0 * Math.log(2.0)) {
            throw new IllegalArgumentException("DigitalNetFromFile:   too many points" + PrintfFormat.NEWLINE);
        }
        if (r1 > this.numRows) {
            throw new IllegalArgumentException("DigitalNetFromFile:   One must have   r1 <= Max num rows" + PrintfFormat.NEWLINE);
        }
        if (s1 > this.dim) {
            throw new IllegalArgumentException("DigitalNetFromFile:   One must have   s1 <= Max dimension" + PrintfFormat.NEWLINE);
        }
        if (w < 0) {
            r1 = w = this.numRows;
            s1 = this.dim;
        }
        if (w < this.numRows) {
            throw new IllegalArgumentException("DigitalNetFromFile:   One must have   w >= numRows" + PrintfFormat.NEWLINE);
        }
        try {
            this.readMatrices(st, r1, this.numCols, s1);
        }
        catch (NumberFormatException e) {
            System.err.println(e + "   cannot read matrices from " + filename);
            throw e;
        }
        catch (IOException e) {
            System.err.println(e + "   cannot read matrices from  " + filename);
            throw e;
        }
        input.close();
        this.filename = filename;
        this.numRows = r1;
        this.dim = s1;
        this.outDigits = w;
        int x = this.b;
        for (int i = 1; i < this.numCols; ++i) {
            x *= this.b;
        }
        if (x != this.numPoints) {
            System.out.println("DigitalNetFromFile:   numPoints != b^k");
            throw new IllegalArgumentException(" numPoints != b^k");
        }
        this.normFactor = 1.0 / Math.pow(this.b, this.outDigits);
        double invb = 1.0 / (double)this.b;
        this.factor = new double[this.outDigits];
        this.factor[0] = invb;
        for (int j = 1; j < this.outDigits; ++j) {
            this.factor[j] = this.factor[j - 1] * invb;
        }
    }

    public DigitalNetFromFile(String filename, int s) throws MalformedURLException, IOException {
        this(filename, -1, -1, s);
    }

    DigitalNetFromFile() {
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("File:   " + this.filename + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        return sb.toString();
    }

    public String toStringDetailed() {
        StringBuffer sb = new StringBuffer(this.toString());
        sb.append(PrintfFormat.NEWLINE + "n = " + this.numPoints + PrintfFormat.NEWLINE);
        sb.append("dim = " + this.dim + PrintfFormat.NEWLINE);
        for (int i = 0; i < this.dim; ++i) {
            sb.append(PrintfFormat.NEWLINE + " // dim = " + (1 + i) + PrintfFormat.NEWLINE);
            for (int c = 0; c < this.numCols; ++c) {
                for (int r = 0; r < this.numRows; ++r) {
                    sb.append(this.genMat[i * this.numCols + c][r] + " ");
                }
                sb.append(PrintfFormat.NEWLINE);
            }
        }
        return sb.toString();
    }

    private static List getListDir(String dirname) throws IOException {
        try {
            String pseudo = "umontreal/ssj/hups/data/";
            StringBuffer pathname = new StringBuffer(pseudo);
            for (int ci = 0; ci < dirname.length(); ++ci) {
                char ch = dirname.charAt(ci);
                if (ch == File.separatorChar) {
                    pathname.append('/');
                    continue;
                }
                pathname.append(ch);
            }
            URL url = DigitalNetFromFile.class.getClassLoader().getResource(pathname.toString());
            File dir = new File(url.getPath());
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(dirname + " is not a directory");
            }
            File[] files = dir.listFiles();
            ArrayList<DigitalNetFromFile> alist = new ArrayList<DigitalNetFromFile>(200);
            if (!dirname.endsWith(File.separator)) {
                dirname = dirname + File.separator;
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() || files[i].getName().endsWith("gz") || files[i].getName().endsWith("zip")) continue;
                DigitalNetFromFile net = new DigitalNetFromFile();
                BufferedReader input = DigitalNetFromFile.openFile(dirname + files[i].getName());
                StreamTokenizer st = new StreamTokenizer(input);
                net.readData(st);
                net.filename = files[i].getName();
                alist.add(net);
            }
            if (alist != null && !files[0].isDirectory()) {
                Collections.sort(alist, new NetComparator());
            }
            return alist;
        }
        catch (NullPointerException e) {
            System.err.println("getListDir: cannot find directory   " + dirname);
            throw e;
        }
        catch (NumberFormatException e) {
            System.err.println(e + "***   cannot read number ");
            throw e;
        }
        catch (IOException e) {
            System.err.println(e);
            throw e;
        }
    }

    private static String listFiles(String dirname) {
        try {
            String pseudo = "umontreal/ssj/hups/data/";
            StringBuffer pathname = new StringBuffer(pseudo);
            for (int ci = 0; ci < dirname.length(); ++ci) {
                char ch = dirname.charAt(ci);
                if (ch == File.separatorChar) {
                    pathname.append('/');
                    continue;
                }
                pathname.append(ch);
            }
            URL url = DigitalNetFromFile.class.getClassLoader().getResource(pathname.toString());
            File dir = new File(url.getPath());
            File[] list = dir.listFiles();
            ArrayList alist = new ArrayList(200);
            int NPRI = 3;
            StringBuffer sb = new StringBuffer(1000);
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    sb.append(PrintfFormat.s(-2, list[i].getName()));
                    sb.append(File.separator + PrintfFormat.NEWLINE);
                    continue;
                }
                sb.append(PrintfFormat.s(-25, list[i].getName()));
                if (i % 3 != 2) continue;
                sb.append(PrintfFormat.NEWLINE);
            }
            if (list.length % 3 > 0) {
                sb.append(PrintfFormat.NEWLINE);
            }
            return sb.toString();
        }
        catch (NullPointerException e) {
            System.err.println("listFiles: cannot find directory   " + dirname);
            throw e;
        }
    }

    public static String listDir(String dirname) throws IOException {
        try {
            List list = DigitalNetFromFile.getListDir(dirname);
            if (list == null || list.size() == 0) {
                return DigitalNetFromFile.listFiles(dirname);
            }
            StringBuffer sb = new StringBuffer(1000);
            sb.append("Directory:   " + dirname + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
            sb.append(PrintfFormat.s(-25, "     File") + PrintfFormat.s(-15, "       Base") + PrintfFormat.s(-10, "Dimension") + PrintfFormat.s(-10, " numRows") + PrintfFormat.s(-10, "numColumns" + PrintfFormat.NEWLINE));
            int base = 0;
            for (int i = 0; i < list.size(); ++i) {
                DigitalNet net = (DigitalNet)list.get(i);
                int j = ((DigitalNetFromFile)net).filename.lastIndexOf(File.separator);
                if (net.b != base) {
                    sb.append("----------------------------------------------------------------------" + PrintfFormat.NEWLINE);
                    base = net.b;
                }
                String name = ((DigitalNetFromFile)net).filename.substring(j + 1);
                sb.append(PrintfFormat.s(-25, name) + PrintfFormat.d(10, net.b) + PrintfFormat.d(10, net.dim) + PrintfFormat.d(10, net.numRows) + PrintfFormat.d(10, net.numCols) + PrintfFormat.NEWLINE);
            }
            return sb.toString();
        }
        catch (NullPointerException e) {
            System.err.println("formatPlain: cannot find directory   " + dirname);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void listDirHTML(String dirname, String filename) throws IOException {
        String list = DigitalNetFromFile.listDir(dirname);
        StreamTokenizer st = new StreamTokenizer(new StringReader(list));
        st.eolIsSignificant(true);
        st.ordinaryChar(47);
        st.ordinaryChar(95);
        st.ordinaryChar(45);
        st.wordChars(45, 45);
        st.wordChars(95, 95);
        st.slashSlashComments(false);
        st.slashStarComments(false);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        out.println("<html>" + PrintfFormat.NEWLINE + "<head>" + PrintfFormat.NEWLINE + "<title>");
        while (st.nextToken() != 10) {
        }
        out.println(PrintfFormat.NEWLINE + "</title>" + PrintfFormat.NEWLINE + "</head>");
        out.println("<body>");
        out.println("<table border>");
        out.println("<caption> Directory: " + dirname + "</caption>");
        st.nextToken();
        st.nextToken();
        while (st.sval.compareTo("File") != 0) {
            st.nextToken();
        }
        out.print("<tr align=center><th>" + st.sval + "</th>");
        while (st.nextToken() != 10) {
            out.print("<th>" + st.sval + "</th>");
        }
        out.println("</tr>" + PrintfFormat.NEWLINE);
        block8: while (true) {
            if (st.nextToken() == -1) {
                out.println("</table>");
                out.println("</body>" + PrintfFormat.NEWLINE + "</html>");
                out.close();
                return;
            }
            switch (st.ttype) {
                case 10: {
                    out.println("</tr>");
                    continue block8;
                }
                case -2: {
                    out.print("<td>" + (int)st.nval + "</td>");
                    continue block8;
                }
                case -3: {
                    if (st.sval.indexOf("---") >= 0) {
                        st.nextToken();
                        continue block8;
                    }
                    out.print("<tr align=center><td>" + st.sval + "</td>");
                    continue block8;
                }
            }
            out.print(st.sval);
        }
    }

    static class NetComparator
    implements Comparator {
        NetComparator() {
        }

        public int compare(Object o1, Object o2) {
            DigitalNetFromFile net1 = (DigitalNetFromFile)o1;
            DigitalNetFromFile net2 = (DigitalNetFromFile)o2;
            if (net1.b < net2.b) {
                return -1;
            }
            if (net1.b > net2.b) {
                return 1;
            }
            if (net1.filename.indexOf("_") >= 0 && net2.filename.indexOf("_") < 0) {
                return 1;
            }
            if (net2.filename.indexOf("_") >= 0 && net1.filename.indexOf("_") < 0) {
                return -1;
            }
            if (net1.dim < net2.dim) {
                return -1;
            }
            if (net1.dim > net2.dim) {
                return 1;
            }
            if (net1.numRows < net2.numRows) {
                return -1;
            }
            if (net1.numRows > net2.numRows) {
                return 1;
            }
            return 0;
        }
    }
}

