/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util.sort;

import java.util.Arrays;
import java.util.Comparator;
import umontreal.ssj.util.sort.HilbertCurveMap;
import umontreal.ssj.util.sort.MultiDim01;
import umontreal.ssj.util.sort.MultiDimSort01;

public class HilbertCurveSort
implements MultiDimSort01<MultiDim01> {
    int dimension;
    long[][] indexForSort;
    HilbertCurveMap hcMap;

    public HilbertCurveSort(int d, int m) {
        this.dimension = d;
        this.hcMap = new HilbertCurveMap(d, m);
    }

    public HilbertCurveSort(HilbertCurveMap map) {
        this.hcMap = map;
        this.dimension = map.dimension();
    }

    public void sort(MultiDim01[] a, int iMin, int iMax) {
        double[][] b = new double[iMax][this.dimension];
        for (int i = iMin; i < iMax; ++i) {
            b[i] = a[i].getPoint();
        }
        this.sort(b, iMin, iMax);
        MultiDim01[] aclone = (MultiDim01[])a.clone();
        for (int i = iMin; i < iMax; ++i) {
            a[i] = aclone[(int)this.indexForSort[i][0]];
        }
    }

    public void sort(MultiDim01[] a) {
        this.sort(a, 0, a.length);
    }

    @Override
    public void sort(double[][] a, int iMin, int iMax) {
        if (iMin + 1 == iMax) {
            return;
        }
        this.indexForSort = new long[iMax][2];
        int[] icoord = new int[this.dimension];
        for (int i = 0; i < a.length; ++i) {
            this.hcMap.pointToCoordinates(a[i], icoord);
            this.indexForSort[i][0] = i;
            this.indexForSort[i][1] = this.hcMap.coordinatesToIndex(icoord);
        }
        HilbertCurveSort.sortIndexOfLong2(this.indexForSort, iMin, iMax);
        double[][] aclone = (double[][])a.clone();
        for (int i = iMin; i < iMax; ++i) {
            a[i] = aclone[(int)this.indexForSort[i][0]];
        }
    }

    @Override
    public void sort(double[][] a) {
        this.sort(a, 0, a.length);
    }

    public long[][] getIndexAfterSort() {
        return this.indexForSort;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    public HilbertCurveMap getHilbertCurveMap() {
        return this.hcMap;
    }

    public static void sortIndexOfLong2(long[][] index, int iMin, int iMax) {
        Arrays.sort(index, iMin, iMax, new LongIndexComparator2());
    }

    public static class LongIndexComparator2
    implements Comparator<long[]> {
        @Override
        public int compare(long[] p1, long[] p2) {
            if (p1[1] > p2[1]) {
                return 1;
            }
            if (p1[1] < p2[1]) {
                return -1;
            }
            return 0;
        }
    }
}

