/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util.sort;

import umontreal.ssj.util.sort.BatchSort;

public class BatchSortPow2
extends BatchSort {
    int[] ej;

    public BatchSortPow2(double[] batchExponents) {
        super(batchExponents);
        this.ej = new int[this.dimension];
    }

    @Override
    public void setBatchNumbers(int n) {
        if (this.batchExponents == null) {
            throw new NullPointerException("batchExponents is null");
        }
        int e = 1;
        while (n > 1 << e) {
            ++e;
        }
        this.nSaved = n;
        this.batchProduct = 1 << e;
        for (int j = 0; j < this.dimension; ++j) {
            this.ej[j] = (int)Math.ceil((double)e * this.batchExponents[j]);
            e -= this.ej[j];
            this.batchNumbers[j] = 1 << this.ej[j];
        }
    }

    public int[] getBitNumbers() {
        return this.ej;
    }
}

