/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.list;

import cern.colt.matrix.DoubleMatrix2D;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.TallyStore;
import umontreal.ssj.stat.list.ListOfStatProbes;

public class ListOfTallies<E extends Tally>
extends ListOfStatProbes<E> {
    public ListOfTallies() {
    }

    public ListOfTallies(String name) {
        super(name);
    }

    public static ListOfTallies<Tally> createWithTally(int size) {
        ListOfTallies<Tally> list = new ListOfTallies<Tally>();
        for (int i = 0; i < size; ++i) {
            list.add(new Tally());
        }
        return list;
    }

    public static ListOfTallies<TallyStore> createWithTallyStore(int size) {
        ListOfTallies<TallyStore> list = new ListOfTallies<TallyStore>();
        for (int i = 0; i < size; ++i) {
            list.add(new TallyStore());
        }
        return list;
    }

    public static ListOfTallies<TallyStore> createWithTallyStore(int size, int t) {
        ListOfTallies<TallyStore> list = new ListOfTallies<TallyStore>();
        for (int i = 0; i < t; ++i) {
            list.add(new TallyStore(size));
        }
        return list;
    }

    public void add(double[] x) {
        int l = this.size();
        if (x.length != l) {
            throw new IllegalArgumentException("Incompatible array length: given " + x.length + ", required " + l);
        }
        if (this.collect) {
            for (int i = 0; i < l; ++i) {
                double v = x[i];
                Tally ta = (Tally)this.get(i);
                if (Double.isNaN(v) || ta == null) continue;
                ta.add(v);
            }
        }
        this.notifyListeners(x);
    }

    public int numberObs() {
        if (this.size() == 0) {
            return 0;
        }
        Tally t0 = (Tally)this.get(0);
        return t0 == null ? 0 : t0.numberObs();
    }

    public boolean areAllNumberObsEqual() {
        int l = this.size();
        int n = this.numberObs();
        for (int i = 1; i < l; ++i) {
            Tally t = (Tally)this.get(i);
            if (t.numberObs() == n) continue;
            return false;
        }
        return true;
    }

    @Override
    public void average(double[] r) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            double v;
            Tally ta = (Tally)this.get(i);
            r[i] = v = ta == null || ta.numberObs() == 0 ? Double.NaN : ta.average();
        }
    }

    public void variance(double[] v) {
        if (this.size() != v.length) {
            throw new IllegalArgumentException("Invalid length of given array");
        }
        for (int i = 0; i < v.length; ++i) {
            Tally tally = (Tally)this.get(i);
            v[i] = tally == null || tally.numberObs() < 2 ? Double.NaN : tally.variance();
        }
    }

    public void standardDeviation(double[] std) {
        if (this.size() != std.length) {
            throw new IllegalArgumentException("Invalid length of given array");
        }
        for (int i = 0; i < std.length; ++i) {
            Tally tally = (Tally)this.get(i);
            std[i] = tally == null || tally.numberObs() < 2 ? Double.NaN : tally.standardDeviation();
        }
    }

    public double covariance(int i, int j) {
        if (i == j) {
            return ((Tally)this.get(i)).variance();
        }
        TallyStore tallyi = (TallyStore)this.get(i);
        TallyStore tallyj = (TallyStore)this.get(j);
        return tallyi.covariance(tallyj);
    }

    public double correlation(int i, int j) {
        if (i == j) {
            return 1.0;
        }
        double cov = this.covariance(i, j);
        Tally tallyi = (Tally)this.get(i);
        Tally tallyj = (Tally)this.get(j);
        if (tallyi == null || tallyj == null) {
            return Double.NaN;
        }
        return cov / Math.sqrt(tallyi.variance() * tallyj.variance());
    }

    public void covariance(DoubleMatrix2D c) {
        int i1;
        int l = this.size();
        if (c.rows() != l) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (c.columns() != l) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (i1 = 0; i1 < l; ++i1) {
            c.setQuick(i1, i1, ((Tally)this.get(i1)).variance());
        }
        for (i1 = 0; i1 < l - 1; ++i1) {
            for (int i2 = i1 + 1; i2 < l; ++i2) {
                double cov = this.covariance(i1, i2);
                c.setQuick(i1, i2, cov);
                c.setQuick(i2, i1, cov);
            }
        }
    }

    public void correlation(DoubleMatrix2D c) {
        int i1;
        int l = this.size();
        if (c.rows() != l) {
            throw new IllegalArgumentException("Invalid number of rows in correlation matrix");
        }
        if (c.columns() != l) {
            throw new IllegalArgumentException("Invalid number of columns in correlation matrix");
        }
        for (i1 = 0; i1 < l; ++i1) {
            c.setQuick(i1, i1, 1.0);
        }
        for (i1 = 0; i1 < l - 1; ++i1) {
            for (int i2 = i1 + 1; i2 < l; ++i2) {
                double cor = this.correlation(i1, i2);
                c.setQuick(i1, i2, cor);
                c.setQuick(i2, i1, cor);
            }
        }
    }

    @Override
    public ListOfTallies<E> clone() {
        return (ListOfTallies)super.clone();
    }
}

