/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import umontreal.ssj.mcqmctools.MonteCarloModel;
import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.anova.RandomIntegrator;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.list.ListOfTallies;

public class Replicator
implements RandomIntegrator {
    protected int nReplicates;
    protected RandomIntegrator integrator;
    protected Tally statValue = null;
    protected ListOfTallies<Tally> statValueList = null;

    public Replicator(int nReplicates, RandomIntegrator integrator) {
        this.nReplicates = nReplicates;
        this.integrator = integrator;
    }

    public RandomIntegrator getIntegrator() {
        return this.integrator;
    }

    public int getNumReplicates() {
        return this.nReplicates;
    }

    @Override
    public int getNumPoints() {
        return this.integrator.getTotalSimulations();
    }

    @Override
    public int getTotalSimulations() {
        return this.getNumReplicates() * this.getNumPoints();
    }

    @Override
    public void setStream(RandomStream stream) {
        this.integrator.setStream(stream);
    }

    @Override
    public RandomStream getStream() {
        return this.integrator.getStream();
    }

    @Override
    public void integrate(MonteCarloModelDouble model, Tally statValue) {
        statValue.init();
        for (int i = 0; i < this.nReplicates; ++i) {
            statValue.add(this.integrator.integrate(model));
        }
    }

    @Override
    public double integrate(MonteCarloModelDouble model) {
        if (this.statValue == null) {
            this.statValue = new Tally();
        } else {
            this.statValue.init();
        }
        this.integrate(model, this.statValue);
        return this.statValue.average();
    }

    @Override
    public void integrate(MonteCarloModel<double[]> model, ListOfTallies<? extends Tally> stat) {
        double[] val = new double[stat.size()];
        ListOfTallies<Tally> innerStat = ListOfTallies.createWithTally(stat.size());
        for (int i = 0; i < this.nReplicates; ++i) {
            innerStat.init();
            this.integrator.integrate(model, innerStat);
            innerStat.average(val);
            stat.add(val);
        }
    }

    @Override
    public void integrate(MonteCarloModel<double[]> model, double[] values) {
        if (this.statValueList == null || this.statValueList.size() != values.length) {
            this.statValueList = ListOfTallies.createWithTally(values.length);
        } else {
            this.statValueList.init();
        }
        this.integrate(model, this.statValueList);
        this.statValueList.average(values);
    }

    public String toString() {
        return "Replicator [replicates=" + this.nReplicates + "] [integrator=" + this.integrator + "]";
    }
}

