/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.mcqmctools.MonteCarloModel;
import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.anova.MonteCarloSampler;
import umontreal.ssj.mcqmctools.anova.RandomIntegrator;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.list.ListOfTallies;

public class MonteCarloIntegrator
extends MonteCarloSampler
implements RandomIntegrator {
    protected Tally statValue = null;
    protected ListOfTallies<Tally> statValueList = null;

    public MonteCarloIntegrator(int samples) {
        super(samples);
    }

    public MonteCarloIntegrator(int samples, RandomStream stream) {
        super(samples, stream);
    }

    @Override
    public int getNumPoints() {
        return this.getNumSamples();
    }

    @Override
    public int getTotalSimulations() {
        return this.getNumSamples();
    }

    @Override
    public void integrate(MonteCarloModelDouble model, Tally statValue) {
        boolean isPointSet = this.stream instanceof PointSetIterator;
        for (int i = 0; i < this.nSamples; ++i) {
            model.simulate(this.stream);
            statValue.add(model.getPerformance());
            if (!isPointSet) continue;
            ((PointSetIterator)this.stream).resetToNextPoint();
        }
    }

    @Override
    public double integrate(MonteCarloModelDouble model) {
        if (this.statValue == null) {
            this.statValue = new Tally();
        } else {
            this.statValue.init();
        }
        this.integrate(model, this.statValue);
        return this.statValue.average();
    }

    @Override
    public void integrate(MonteCarloModel<double[]> model, ListOfTallies<? extends Tally> statValue) {
        boolean isPointSet = this.stream instanceof PointSetIterator;
        for (int i = 0; i < this.nSamples; ++i) {
            model.simulate(this.stream);
            statValue.add(model.getPerformance());
            if (!isPointSet) continue;
            ((PointSetIterator)this.stream).resetToNextPoint();
        }
    }

    @Override
    public void integrate(MonteCarloModel<double[]> model, double[] values) {
        if (this.statValueList == null || this.statValueList.size() != values.length) {
            this.statValueList = ListOfTallies.createWithTally(values.length);
        } else {
            this.statValueList.init();
        }
        this.integrate(model, this.statValueList);
        this.statValueList.average(values);
    }

    @Override
    public String toString() {
        String s = "Monte Carlo Integrator [samples=" + this.getNumSamples() + "]";
        if (this.getStream() != null) {
            s = s + " [stream=" + this.getStream().getClass().getSimpleName() + "]";
        }
        return s;
    }
}

