/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.util.logging.Level;
import java.util.logging.Logger;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.util.PrintfFormat;

public class TallyStore
extends Tally {
    private DoubleArrayList array = null;
    private Logger log = Logger.getLogger("umontreal.ssj.stat");

    public TallyStore() {
        this.array = new DoubleArrayList();
    }

    public TallyStore(String name) {
        super(name);
        this.array = new DoubleArrayList();
    }

    public TallyStore(int capacity) {
        this.array = new DoubleArrayList(capacity);
    }

    public TallyStore(String name, int capacity) {
        super(name);
        this.array = new DoubleArrayList(capacity);
    }

    public TallyStore(DoubleArrayList a) {
        this.array = a;
        this.array.clear();
    }

    @Override
    public void init() {
        super.init();
        if (this.array != null) {
            this.array.clear();
        }
    }

    @Override
    public void add(double x) {
        if (this.collect) {
            this.array.add(x);
        }
        super.add(x);
    }

    public double[] getArray() {
        this.array.trimToSize();
        return this.array.elements();
    }

    public DoubleArrayList getDoubleArrayList() {
        this.array.trimToSize();
        return this.array;
    }

    public void quickSort() {
        this.array.quickSort();
    }

    public double covariance(TallyStore t2) {
        if (this.numberObs() != t2.numberObs()) {
            this.log.logp(Level.WARNING, "TallyStore", "covariance", "This tally, with name " + this.getName() + ", contains " + this.numberObs() + " observations while the given tally, with name " + t2.getName() + ", contains " + t2.numberObs() + "observations");
            return Double.NaN;
        }
        if (this.numberObs() < 2 || t2.numberObs() < 2) {
            this.log.logp(Level.WARNING, "TallyStore", "covariance", "This tally, with name " + this.getName() + ", contains " + this.numberObs() + " observation");
            return Double.NaN;
        }
        return Descriptive.covariance((DoubleArrayList)this.getDoubleArrayList(), (DoubleArrayList)t2.getDoubleArrayList());
    }

    @Override
    public TallyStore clone() {
        TallyStore t = (TallyStore)super.clone();
        t.array = (DoubleArrayList)this.array.clone();
        return t;
    }

    public TallyStore extractSubrange(double a, double b) {
        int numObs = this.numberObs();
        double[] obs = this.getArray();
        TallyStore t = new TallyStore();
        for (int i = 0; i < numObs; ++i) {
            double x = obs[i];
            if (!(x > a & x < b)) continue;
            t.add(x);
        }
        return t;
    }

    public TallyStore aggregate(int gsize) {
        int j;
        double sum;
        int numObs = this.numberObs();
        int numGroups = numObs / gsize;
        double[] obs = this.getArray();
        TallyStore t = new TallyStore(numGroups);
        for (int i = 0; i < numGroups; ++i) {
            sum = 0.0;
            for (j = 0; j < gsize; ++j) {
                sum += obs[gsize * i + j];
            }
            t.add(sum /= (double)gsize);
        }
        int rest = numObs - numGroups * gsize;
        if (rest > 0) {
            sum = 0.0;
            for (j = 0; j < rest; ++j) {
                sum += obs[gsize * numGroups + j];
            }
            t.add(sum /= (double)rest);
        }
        return t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.numberObs(); ++i) {
            sb.append(i + "    " + this.array.getQuick(i) + PrintfFormat.NEWLINE);
        }
        return sb.toString();
    }
}

