/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.simevents.eventlist;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.ssj.simevents.Event;
import umontreal.ssj.simevents.eventlist.EventList;
import umontreal.ssj.util.PrintfFormat;

public class DoublyLinked
implements EventList {
    private int modCount = 0;
    private Node first = null;
    private Node last = null;

    @Override
    public boolean isEmpty() {
        return this.first == null;
    }

    @Override
    public void clear() {
        if (this.first == null) {
            return;
        }
        this.last.succ = null;
        this.first = null;
        this.last = null;
        ++this.modCount;
    }

    @Override
    public void add(Event ev) {
        Node newNode = new Node();
        newNode.ev = ev;
        ++this.modCount;
        if (this.last == null) {
            this.first = this.last = newNode;
            this.first.succ = null;
            this.first.prec = null;
            return;
        }
        Node node = this.findPosition(ev);
        if (node == null) {
            newNode.succ = this.first;
            newNode.succ.prec = newNode;
            this.first = newNode;
            newNode.prec = null;
        } else {
            newNode.prec = node;
            newNode.succ = node.succ;
            node.succ = newNode;
            if (newNode.succ != null) {
                newNode.succ.prec = newNode;
            } else {
                this.last = newNode;
            }
        }
    }

    @Override
    public void addFirst(Event ev) {
        Node newNode = new Node();
        newNode.ev = ev;
        newNode.prec = null;
        if (this.first == null) {
            this.first = this.last = newNode;
            this.first.succ = null;
        } else {
            newNode.succ = this.first;
            this.first.prec = newNode;
            this.first = newNode;
        }
        ++this.modCount;
    }

    @Override
    public void addBefore(Event ev, Event other) {
        Node node = this.last;
        while (node != null && node.ev.compareTo(other) >= 0 && node.ev != other) {
            node = node.prec;
        }
        if (node.ev != other) {
            throw new IllegalArgumentException("Event not in list.");
        }
        Node newNode = new Node();
        newNode.ev = ev;
        newNode.prec = node.prec;
        newNode.succ = node;
        node.prec = newNode;
        if (newNode.prec != null) {
            newNode.prec.succ = newNode;
        } else {
            this.first = newNode;
        }
        ++this.modCount;
    }

    @Override
    public void addAfter(Event ev, Event other) {
        Node node = this.last;
        while (node != null && node.ev.compareTo(other) >= 0 && node.ev != other) {
            node = node.prec;
        }
        if (node.ev != other) {
            throw new IllegalArgumentException("Event not in list.");
        }
        Node newNode = new Node();
        newNode.ev = ev;
        newNode.prec = node;
        newNode.succ = node.succ;
        node.succ = newNode;
        if (newNode.succ != null) {
            newNode.succ.prec = newNode;
        } else {
            this.last = newNode;
        }
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        return this.first == null ? null : this.first.ev;
    }

    @Override
    public Event getFirstOfClass(String cl) {
        Node node = this.first;
        while (node != null) {
            if (node.ev.getClass().getName().equals(cl)) {
                return node.ev;
            }
            node = node.succ;
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> cl) {
        Node node = this.first;
        while (node != null) {
            if (node.ev.getClass() == cl) {
                return (E)node.ev;
            }
            node = node.succ;
        }
        return null;
    }

    @Override
    public boolean remove(Event ev) {
        Node node = this.last;
        while (node != null && node.ev.compareTo(ev) >= 0 && node.ev != ev) {
            node = node.prec;
        }
        if (node == null || node.ev != ev) {
            return false;
        }
        if (node == this.last && node == this.first) {
            this.first = null;
            this.last = null;
        } else {
            if (node == this.last) {
                this.last = node.prec;
                this.last.succ = null;
            } else {
                node.succ.prec = node.prec;
            }
            if (node == this.first) {
                this.first = node.succ;
                this.first.prec = null;
            } else {
                node.prec.succ = node.succ;
                node.prec = null;
            }
        }
        node.ev = null;
        node.succ = null;
        ++this.modCount;
        return true;
    }

    @Override
    public Event removeFirst() {
        if (this.first == null) {
            return null;
        }
        Event ev = this.first.ev;
        Node temp = this.first;
        this.first = this.first.succ;
        if (this.first == null) {
            this.last = null;
        } else {
            this.first.prec = null;
        }
        temp.ev = null;
        temp.succ = null;
        ++this.modCount;
        return ev;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new DLItr();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Contents of the event list DoublyLinked:");
        Node node = this.first;
        while (node != null) {
            sb.append(PrintfFormat.NEWLINE + PrintfFormat.g(12, 7, node.ev.time()) + ", " + PrintfFormat.g(8, 4, node.ev.priority()) + " : " + node.ev.toString());
            node = node.succ;
        }
        return sb.toString();
    }

    private Node findPosition(Event ev) {
        Node node = this.last;
        while (node != null && ev.compareTo(node.ev) < 0) {
            node = node.prec;
        }
        return node;
    }

    private class DLItr
    implements ListIterator<Event> {
        private Node prev = null;
        private Node next;
        private Node lastRet;
        private int expectedModCount;
        private int nextIndex;

        DLItr() {
            this.next = DoublyLinked.this.first;
            this.expectedModCount = DoublyLinked.this.modCount;
            this.lastRet = null;
            this.nextIndex = 0;
        }

        @Override
        public void add(Event ev) {
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next != null && ev.compareTo(this.next.ev) > 0) {
                ev.setTime(this.next.ev.time());
                ev.setPriority(this.next.ev.priority());
            }
            if (this.prev != null && ev.compareTo(this.prev.ev) < 0) {
                ev.setTime(this.prev.ev.time());
                ev.setPriority(this.prev.ev.priority());
            }
            Node newNode = new Node();
            newNode.ev = ev;
            ++this.nextIndex;
            ++DoublyLinked.this.modCount;
            ++this.expectedModCount;
            this.lastRet = null;
            if (DoublyLinked.this.last == null) {
                DoublyLinked.this.first = (DoublyLinked.this.last = newNode);
                ((DoublyLinked)DoublyLinked.this).first.succ = null;
                ((DoublyLinked)DoublyLinked.this).first.prec = null;
                this.prev = newNode;
                this.next = null;
                this.nextIndex = 1;
            } else if (this.prev == null) {
                newNode.succ = DoublyLinked.this.first;
                newNode.succ.prec = newNode;
                DoublyLinked.this.first = newNode;
                newNode.prec = null;
                this.prev = newNode;
            } else {
                newNode.prec = this.prev;
                newNode.succ = this.next;
                this.prev.succ = newNode;
                if (newNode.succ != null) {
                    newNode.succ.prec = newNode;
                } else {
                    DoublyLinked.this.last = newNode;
                }
                this.prev = newNode;
            }
        }

        @Override
        public boolean hasNext() {
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.prev != null;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event ev = this.next.ev;
            this.lastRet = this.next;
            this.prev = this.next;
            this.next = this.next.succ;
            return ev;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event ev = this.prev.ev;
            this.lastRet = this.prev;
            this.next = this.prev;
            this.prev = this.prev.prec;
            return ev;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet == this.next) {
                this.next = this.next.succ;
            } else {
                this.prev = this.prev.prec;
                --this.nextIndex;
            }
            if (this.lastRet == DoublyLinked.this.last && this.lastRet == DoublyLinked.this.first) {
                DoublyLinked.this.last = (DoublyLinked.this.first = null);
                this.prev = null;
                this.next = null;
            } else {
                if (this.lastRet == DoublyLinked.this.last) {
                    DoublyLinked.this.last = this.lastRet.prec;
                    ((DoublyLinked)DoublyLinked.this).last.succ = null;
                } else {
                    this.lastRet.succ.prec = this.lastRet.prec;
                }
                if (this.lastRet == DoublyLinked.this.first) {
                    DoublyLinked.this.first = this.lastRet.succ;
                    ((DoublyLinked)DoublyLinked.this).first.prec = null;
                } else {
                    this.lastRet.prec.succ = this.lastRet.succ;
                    this.lastRet.prec = null;
                }
            }
            this.lastRet.ev = null;
            this.lastRet.succ = null;
            this.lastRet = null;
            ++DoublyLinked.this.modCount;
            ++this.expectedModCount;
        }

        @Override
        public void set(Event ev) {
            if (DoublyLinked.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.prec != null && ev.compareTo(this.lastRet.prec.ev) < 0) {
                ev.setTime(this.lastRet.prec.ev.time());
                ev.setPriority(this.lastRet.prec.ev.priority());
            }
            if (this.lastRet.succ != null && ev.compareTo(this.lastRet.succ.ev) > 0) {
                ev.setTime(this.lastRet.succ.ev.time());
                ev.setPriority(this.lastRet.succ.ev.priority());
            }
            this.lastRet.ev = ev;
        }
    }

    private static class Node {
        Event ev;
        Node prec;
        Node succ;

        private Node() {
        }
    }
}

