/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import umontreal.ssj.charts.XYLineChart;
import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.functionfit.LeastSquares;
import umontreal.ssj.util.Num;
import umontreal.ssj.util.PrintfFormat;

public class DiscrepancyContainer {
    private double[][] disc;
    private Discrepancy[] discrepancies;
    private double[] regression;
    private int n;
    private int nbDisc;
    private String title;
    private String xLabel;
    private String yLabel;

    public DiscrepancyContainer(Discrepancy[] discrepancies) {
        this.discrepancies = discrepancies;
        this.nbDisc = discrepancies.length;
        this.regression = new double[this.nbDisc + 1];
    }

    public void init(int n, String title, String xLabel, String yLabel) {
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.n = n;
        this.disc = new double[this.nbDisc + 1][n];
        this.reset();
    }

    public void init(int n) {
        this.init(n, "", "Parameter", "Discrepancy");
    }

    public void reset(int i) {
        for (int j = 0; j < this.nbDisc; ++j) {
            this.disc[j + 1][i] = 0.0;
        }
    }

    public void reset() {
        for (int i = 0; i < this.n; ++i) {
            this.reset(i);
        }
    }

    public void compute(int i, double[] points, int n) {
        for (int j = 0; j < this.nbDisc; ++j) {
            this.disc[j + 1][i] = this.discrepancies[j].compute(points, n);
        }
    }

    public void compute(int i, double[][] points, int n, int s) {
        for (int j = 0; j < this.nbDisc; ++j) {
            this.disc[j + 1][i] = this.discrepancies[j].compute(points, n, s);
        }
    }

    public void add(int i, double[] points, int n) {
        for (int j = 0; j < this.nbDisc; ++j) {
            double[] dArray = this.disc[j + 1];
            int n2 = i;
            dArray[n2] = dArray[n2] + this.discrepancies[j].compute(points, n);
        }
    }

    public void addSquare(int i, double[] points, int n) {
        for (int j = 0; j < this.nbDisc; ++j) {
            double discrepancy = this.discrepancies[j].compute(points, n);
            double[] dArray = this.disc[j + 1];
            int n2 = i;
            dArray[n2] = dArray[n2] + discrepancy * discrepancy;
        }
    }

    public void add(int i, double[][] points, int n, int s) {
        for (int j = 0; j < this.nbDisc; ++j) {
            double[] dArray = this.disc[j + 1];
            int n2 = i;
            dArray[n2] = dArray[n2] + this.discrepancies[j].compute(points, n, s);
        }
    }

    public void addSquare(int i, double[][] points, int n, int s) {
        for (int j = 0; j < this.nbDisc; ++j) {
            double discrepancy = this.discrepancies[j].compute(points, n, s);
            double[] dArray = this.disc[j + 1];
            int n2 = i;
            dArray[n2] = dArray[n2] + discrepancy * discrepancy;
        }
    }

    public void scale(int i, double scale) {
        for (int j = 0; j < this.nbDisc; ++j) {
            double[] dArray = this.disc[j + 1];
            int n = i;
            dArray[n] = dArray[n] * scale;
        }
    }

    public void scale(double scale) {
        for (int i = 0; i < this.n; ++i) {
            this.scale(i, scale);
        }
    }

    public void log2(int i) {
        for (int j = 0; j < this.nbDisc; ++j) {
            this.disc[j + 1][i] = Num.log2(this.disc[j + 1][i]);
        }
    }

    public void square(int i) {
        for (int j = 0; j < this.nbDisc; ++j) {
            double[] dArray = this.disc[j + 1];
            int n = i;
            dArray[n] = dArray[n] * this.disc[j + 1][i];
        }
    }

    public void setParam(int i, double paramValue) {
        this.disc[0][i] = paramValue;
    }

    private void removeInfinite() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.nbDisc; ++j) {
                if (this.disc[j + 1][i] != Double.NEGATIVE_INFINITY) continue;
                this.disc[j + 1][i] = 0.0;
            }
        }
    }

    protected void calcRegressionSlope() {
        for (int j = 0; j < this.nbDisc; ++j) {
            this.regression[j] = LeastSquares.calcCoefficients(this.disc[0], this.disc[j + 1], 1)[1];
        }
    }

    public String regressionToString() {
        this.calcRegressionSlope();
        StringBuffer sb = new StringBuffer("***************************************************************" + PrintfFormat.NEWLINE);
        sb.append("Linear regression slope" + PrintfFormat.NEWLINE);
        for (int j = 0; j < this.nbDisc; ++j) {
            sb.append(PrintfFormat.s(15, this.discrepancies[j].toString()) + PrintfFormat.g(15, 6, this.regression[j]) + PrintfFormat.NEWLINE);
        }
        return sb.toString();
    }

    public void toTexFile(String filename) {
        this.removeInfinite();
        XYLineChart chart = new XYLineChart();
        chart.setTitle(this.title);
        chart.getXAxis().setLabel(this.xLabel);
        chart.getYAxis().setLabel(this.yLabel);
        for (int j = 0; j < this.nbDisc; ++j) {
            chart.add(this.disc[0], this.disc[j + 1], this.discrepancies[j].toString(), "sharp plot");
        }
        try {
            FileWriter file = new FileWriter(filename + ".tex");
            file.write(chart.toLatex(9.0, 5.0));
            ((Writer)file).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toDatFile(String filename, String header) {
        try {
            FileWriter file = new FileWriter(filename + ".dat");
            file.write(header);
            file.write(this.toString());
            file.write(this.regressionToString());
            ((Writer)file).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(PrintfFormat.NEWLINE);
        sb.append(PrintfFormat.s(35, this.xLabel));
        for (int i = 0; i < this.n; ++i) {
            sb.append(PrintfFormat.g(15, 6, this.disc[0][i]));
        }
        sb.append(PrintfFormat.NEWLINE);
        for (int j = 0; j < this.nbDisc; ++j) {
            sb.append(PrintfFormat.s(15, this.yLabel));
            sb.append(PrintfFormat.s(20, this.discrepancies[j].toString()));
            for (int i = 0; i < this.n; ++i) {
                sb.append(PrintfFormat.g(15, 6, this.disc[j + 1][i]));
            }
            sb.append(PrintfFormat.NEWLINE);
        }
        return sb.toString();
    }
}

