/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.rng;

import umontreal.ssj.rng.RandomStreamBase;

public class WELL512
extends RandomStreamBase {
    private static final long serialVersionUID = 120307L;
    private static final double NORM = 2.3283064359965952E-10;
    private static final int W = 32;
    private static final int R = 16;
    private static final int P = 0;
    private static final int M1 = 13;
    private static final int M2 = 9;
    private static final int M3 = 5;
    private static final int MASK = 15;
    private int state_i;
    private int[] state = new int[16];
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream = new int[]{-1555972198, -1343975397, 1796267544, 100537376, -460645732, 1493885278, -974421337, 938128121, -1864251670, 988166402, 1935526172, -1876018548, 1823640157, -2072713263, -2076311133, 1517514991};
    private static final int[] pw = new int[]{671091113, 836903376, -1609825642, 1983727915, 1669815157, -282407878, 335578015, 1577878822, 85254427, 1454610660, -1808348999, -1495788789, -1062958472, 648894416, -1549744598, 1072786587};
    private static final int[] pz = new int[]{-848760066, 406754970, 1979992494, -1441995442, -78421073, 2044652187, -278477546, 271926219, 609032855, 1970322577, 824197063, 1163829962, -679660931, -658069444, -988084761, 806098177};

    private void advanceSeed(int[] seed, int[] p) {
        int i;
        int[] x = new int[16];
        for (i = 0; i < 16; ++i) {
            this.state[i] = seed[i];
        }
        this.state_i = 0;
        for (int j = 0; j < 16; ++j) {
            int b = p[j];
            for (int k = 0; k < 32; ++k) {
                if ((b & 1) == 1) {
                    for (int i2 = 0; i2 < 16; ++i2) {
                        int n = i2;
                        x[n] = x[n] ^ this.state[this.state_i + i2 & 0xF];
                    }
                }
                b >>= 1;
                this.nextValue();
            }
        }
        for (i = 0; i < 16; ++i) {
            seed[i] = x[i];
        }
    }

    private static void verifySeed(int[] seed) {
        if (seed.length < 16) {
            throw new IllegalArgumentException("Seed must contain 16values");
        }
        for (int i = 0; i < 16; ++i) {
            if (seed[i] == 0) continue;
            return;
        }
        throw new IllegalArgumentException("At least one of the element of the seed must not be 0.");
    }

    private WELL512(int i) {
        for (int j = 0; j < 16; ++j) {
            this.state[j] = 0;
        }
        this.state[i / 32] = 1 << i % 32;
        this.state_i = 0;
    }

    public WELL512() {
        this.stream = new int[16];
        this.substream = new int[16];
        for (int i = 0; i < 16; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.advanceSeed(curr_stream, pz);
        this.resetStartStream();
    }

    public WELL512(String name) {
        this();
        this.name = name;
    }

    public static void setPackageSeed(int[] seed) {
        WELL512.verifySeed(seed);
        for (int i = 0; i < 16; ++i) {
            WELL512.curr_stream[i] = seed[i];
        }
    }

    public void setSeed(int[] seed) {
        WELL512.verifySeed(seed);
        for (int i = 0; i < 16; ++i) {
            this.stream[i] = seed[i];
        }
        this.resetStartStream();
    }

    public int[] getState() {
        int[] result = new int[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = this.state[this.state_i + i & 0xF];
        }
        return result;
    }

    @Override
    public WELL512 clone() {
        WELL512 retour = null;
        retour = (WELL512)super.clone();
        retour.state = new int[16];
        retour.substream = new int[16];
        retour.stream = new int[16];
        for (int i = 0; i < 16; ++i) {
            retour.state[i] = this.state[i];
            retour.substream[i] = this.substream[i];
            retour.stream[i] = this.stream[i];
        }
        return retour;
    }

    @Override
    public void resetStartStream() {
        for (int i = 0; i < 16; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    @Override
    public void resetStartSubstream() {
        this.state_i = 0;
        for (int i = 0; i < 16; ++i) {
            this.state[i] = this.substream[i];
        }
    }

    @Override
    public void resetNextSubstream() {
        this.advanceSeed(this.substream, pw);
        this.resetStartSubstream();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name == null) {
            sb.append("The state of this WELL512 is : {");
        } else {
            sb.append("The state of " + this.name + " is : {");
        }
        for (int i = 0; i < 15; ++i) {
            sb.append(this.state[this.state_i + i & 0xF] + ", ");
        }
        sb.append(this.state[this.state_i + 16 - 1 & 0xF] + "}");
        return sb.toString();
    }

    @Override
    protected double nextValue() {
        int z0 = this.state[this.state_i + 15 & 0xF];
        int z1 = this.state[this.state_i] ^ this.state[this.state_i] << 16 ^ (this.state[this.state_i + 13 & 0xF] ^ this.state[this.state_i + 13 & 0xF] << 15);
        int z2 = this.state[this.state_i + 9 & 0xF] ^ this.state[this.state_i + 9 & 0xF] >>> 11;
        this.state[this.state_i] = z1 ^ z2;
        this.state[this.state_i + 15 & 0xF] = z0 ^ z0 << 2 ^ (z1 ^ z1 << 18) ^ z2 << 28 ^ (this.state[this.state_i] ^ this.state[this.state_i] << 5 & 0xDA442D24);
        this.state_i = this.state_i + 15 & 0xF;
        long result = this.state[this.state_i];
        return (double)(result > 0L ? result : result + 0x100000000L) * 2.3283064359965952E-10;
    }
}

