/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import cern.colt.list.AbstractList;
import cern.colt.list.DoubleArrayList;
import umontreal.ssj.hups.CycleBasedPointSet;
import umontreal.ssj.util.PrintfFormat;

public class LCGPointSet
extends CycleBasedPointSet {
    private int a;

    public LCGPointSet(int n, int a) {
        int i;
        this.a = a;
        double invn = 1.0 / (double)n;
        boolean[] stateVisited = new boolean[n];
        for (i = 0; i < n; ++i) {
            stateVisited[i] = false;
        }
        int startState = 0;
        this.numPoints = 0;
        while (startState < n) {
            stateVisited[startState] = true;
            DoubleArrayList c = new DoubleArrayList();
            c.add((double)startState * invn);
            long currentState = (long)startState * (long)a % (long)n;
            while (currentState != (long)startState) {
                stateVisited[(int)currentState] = true;
                c.add((double)currentState * invn);
                currentState = currentState * (long)a % (long)n;
            }
            this.addCycle((AbstractList)c);
            for (i = startState + 1; i < n && stateVisited[i]; ++i) {
            }
            startState = i;
        }
    }

    public LCGPointSet(int b, int e, int c, int a) {
        this(LCGPointSet.computeModulus(b, e, c), a);
    }

    private static int computeModulus(int b, int e, int c) {
        int n;
        if (b == 2) {
            n = 1 << e;
        } else {
            n = b;
            for (int i = 1; i < e; ++i) {
                n *= b;
            }
        }
        return n += c;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("LCGPointSet:" + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        sb.append(PrintfFormat.NEWLINE + "Multiplier a: ");
        sb.append(this.a);
        return sb.toString();
    }

    public int geta() {
        return this.a;
    }
}

