/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.Distribution;
import umontreal.ssj.rng.RandomStream;

public class RandomVariateGen {
    protected RandomStream stream;
    protected Distribution dist;

    protected RandomVariateGen() {
    }

    public RandomVariateGen(RandomStream s, Distribution dist) {
        this.stream = s;
        this.dist = dist;
    }

    public double nextDouble() {
        return this.dist.inverseF(this.stream.nextDouble());
    }

    public void nextArrayOfDouble(double[] v, int start, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive.");
        }
        for (int i = 0; i < n; ++i) {
            v[start + i] = this.nextDouble();
        }
    }

    public RandomStream getStream() {
        return this.stream;
    }

    public void setStream(RandomStream stream) {
        this.stream = stream;
    }

    public Distribution getDistribution() {
        return this.dist;
    }

    public String toString() {
        if (this.dist != null) {
            return this.getClass().getSimpleName() + " with  " + this.dist.toString();
        }
        return this.getClass().getSimpleName();
    }
}

