/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.randvar.InverseGaussianGen;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.randvar.NormalInverseGaussianGen;

public class NormalInverseGaussianIGGen
extends NormalInverseGaussianGen {
    private NormalGen genN;
    private InverseGaussianGen genIG;

    public NormalInverseGaussianIGGen(InverseGaussianGen ig, NormalGen ng, double beta, double mu) {
        super(null, null);
        this.setParams(ig, ng, beta, mu);
    }

    public static double nextDouble(InverseGaussianGen ig, NormalGen ng, double beta, double mu) {
        return NormalInverseGaussianIGGen.mynig(ig, ng, beta, mu);
    }

    @Override
    public double nextDouble() {
        return NormalInverseGaussianIGGen.mynig(this.genIG, this.genN, this.beta, this.mu);
    }

    private static double mynig(InverseGaussianGen ig, NormalGen ng, double beta, double mu) {
        double y = ig.nextDouble();
        double x = mu + beta * y + Math.sqrt(y) * ng.nextDouble();
        return x;
    }

    protected void setParams(InverseGaussianGen ig, NormalGen ng, double beta, double mu) {
        this.delta = Math.sqrt(ig.getLambda());
        this.gamma = this.delta / ig.getMu();
        this.alpha = Math.sqrt(this.gamma * this.gamma + beta * beta);
        this.setParams(this.alpha, beta, mu, this.delta);
        this.genN = ng;
        this.genIG = ig;
    }
}

