/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.DT;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RQD
extends AbstractSegment {
    public RQD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Requisition Line Number");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Item Code - Internal");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Item Code - External");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Hospital Item Code");
            this.add(NM.class, false, 1, 6, new Object[]{this.getMessage()}, "Requisition Quantity");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Requisition Unit of Measure");
            this.add(ID.class, false, 1, 30, new Object[]{this.getMessage(), new Integer(0)}, "Department Cost Center");
            this.add(ID.class, false, 1, 30, new Object[]{this.getMessage(), new Integer(0)}, "Item Natural Account Code");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Deliver To ID");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Date Needed");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RQD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getRequisitionLineNumber() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getRqd1_RequisitionLineNumber() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getItemCodeInternal() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRqd2_ItemCodeInternal() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getItemCodeExternal() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getRqd3_ItemCodeExternal() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getHospitalItemCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getRqd4_HospitalItemCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getRequisitionQuantity() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getRqd5_RequisitionQuantity() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRequisitionUnitOfMeasure() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getRqd6_RequisitionUnitOfMeasure() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getDepartmentCostCenter() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getRqd7_DepartmentCostCenter() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getItemNaturalAccountCode() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getRqd8_ItemNaturalAccountCode() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getDeliverToID() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getRqd9_DeliverToID() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getDateNeeded() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public DT getRqd10_DateNeeded() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

