/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.RQI_I01_GUARANTOR_INSURANCE;
import ca.uhn.hl7v2.model.v23.group.RQI_I01_PRDCTD;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NK1;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RQI_I01
extends AbstractMessage {
    public RQI_I01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RQI_I01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(RQI_I01_PRDCTD.class, true, true);
            this.add(PID.class, true, false);
            this.add(NK1.class, false, true);
            this.add(RQI_I01_GUARANTOR_INSURANCE.class, false, false);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RQI_I01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public RQI_I01_PRDCTD getPRDCTD() {
        return (RQI_I01_PRDCTD)this.getTyped("PRDCTD", RQI_I01_PRDCTD.class);
    }

    public RQI_I01_PRDCTD getPRDCTD(int rep) {
        return (RQI_I01_PRDCTD)this.getTyped("PRDCTD", rep, RQI_I01_PRDCTD.class);
    }

    public int getPRDCTDReps() {
        return this.getReps("PRDCTD");
    }

    public List<RQI_I01_PRDCTD> getPRDCTDAll() throws HL7Exception {
        return this.getAllAsList("PRDCTD", RQI_I01_PRDCTD.class);
    }

    public void insertPRDCTD(RQI_I01_PRDCTD structure, int rep) throws HL7Exception {
        super.insertRepetition("PRDCTD", (Structure)structure, rep);
    }

    public RQI_I01_PRDCTD insertPRDCTD(int rep) throws HL7Exception {
        return (RQI_I01_PRDCTD)super.insertRepetition("PRDCTD", rep);
    }

    public RQI_I01_PRDCTD removePRDCTD(int rep) throws HL7Exception {
        return (RQI_I01_PRDCTD)super.removeRepetition("PRDCTD", rep);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public RQI_I01_GUARANTOR_INSURANCE getGUARANTOR_INSURANCE() {
        return (RQI_I01_GUARANTOR_INSURANCE)this.getTyped("GUARANTOR_INSURANCE", RQI_I01_GUARANTOR_INSURANCE.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

