/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.wiki;

import java.io.File;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.debux.webmotion.server.WebMotionController;
import org.debux.webmotion.server.call.HttpContext;
import org.debux.webmotion.server.render.Render;
import org.debux.webmotion.wiki.service.WikiConfig;
import org.debux.webmotion.wiki.service.WikiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Page
extends WebMotionController {
    private static final Logger log = LoggerFactory.getLogger(Page.class);
    protected WikiService service;

    public Page() {
        this(new WikiService());
    }

    public Page(WikiService service) {
        this.service = service;
    }

    protected String getLanguage() {
        HttpContext context = this.getContext();
        HttpSession session = context.getSession();
        String language = (String)Config.get((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale");
        return language;
    }

    public Render firstPage() throws Exception {
        String firstPage = WikiConfig.instance.getFirstPage();
        return this.renderURL(firstPage, new Object[0]);
    }

    public Render display(String nameSpace, String pageName) throws Exception {
        String url = null;
        url = nameSpace != null ? "/" + nameSpace + "/" + pageName : "/" + pageName;
        File page = this.service.findPage(nameSpace, pageName, this.getLanguage());
        if (page != null) {
            return this.renderView("page/display.jsp", new Object[]{"nameSpace", nameSpace, "pageName", pageName, "url", url});
        }
        return this.renderView("page/create.jsp", new Object[]{"nameSpace", nameSpace, "pageName", pageName, "url", url});
    }

    public Render include(String nameSpace, String pageName) throws Exception {
        String content = this.service.evalContent(nameSpace, pageName, this.getLanguage());
        if (content != null) {
            return this.renderContent(content, "text/html");
        }
        return null;
    }

    public Render edit(String nameSpace, String pageName) throws Exception {
        String url = null;
        url = nameSpace != null ? "/" + nameSpace + "/" + pageName : "/" + pageName;
        String type = this.service.getType(nameSpace, pageName, this.getLanguage());
        return this.renderView("page/edit.jsp", new Object[]{"nameSpace", nameSpace, "pageName", pageName, "type", type, "url", url});
    }

    public Render source(String nameSpace, String pageName) throws Exception {
        String content = this.service.getContent(nameSpace, pageName, this.getLanguage());
        if (content != null) {
            return this.renderContent(content, "text/plain");
        }
        return this.renderContent("", "text/plain");
    }

    public Render preview(String type, String content) throws Exception {
        String generated = this.service.generate(type, content);
        return this.renderContent(generated, "text/html");
    }

    public Render create(String nameSpace, String pageName, String type) throws Exception {
        this.service.createPage(nameSpace, pageName, this.getLanguage(), type);
        if (nameSpace == null) {
            return this.renderURL("/" + pageName, new Object[]{"action", "edit"});
        }
        return this.renderURL("/" + nameSpace + "/" + pageName, new Object[]{"action", "edit"});
    }

    public Render save(String nameSpace, String pageName, String content) throws Exception {
        this.service.save(nameSpace, pageName, this.getLanguage(), content);
        if (nameSpace == null) {
            return this.renderURL("/" + pageName, new Object[0]);
        }
        return this.renderURL("/" + nameSpace + "/" + pageName, new Object[0]);
    }

    public Render map(String nameSpace) throws Exception {
        String url = "";
        if (nameSpace != null) {
            url = "/" + nameSpace;
        }
        Map map = this.service.getSiteMap(nameSpace);
        return this.renderView("page/map.jsp", new Object[]{"map", map, "url", url});
    }
}

