/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.Mode;
import cryptix.jce.provider.cipher.Padding;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class BlockCipher
extends CipherSpi {
    private int state = 0;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_DECRYPT = 1;
    private static final int STATE_ENCRYPT = 2;
    private final int BLOCK_SIZE;
    private Key key;
    private String algorithm;
    private Padding padding;
    private Mode mode;

    protected BlockCipher(int blockSize) {
        this("", blockSize);
    }

    protected BlockCipher(String algorithm, int blockSize) {
        this.BLOCK_SIZE = blockSize;
        this.algorithm = algorithm;
        try {
            this.mode = Mode.getInstance("ECB", this);
            this.padding = Padding.getInstance("None", this.mode);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new InternalError("PANIC: Installation corrupt, default padding not available.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("PANIC: Installation corrupt, default mode not available.");
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    abstract void coreCrypt(byte[] var1, int var2, byte[] var3, int var4);

    int coreGetBlockSize() {
        return this.BLOCK_SIZE;
    }

    abstract void coreInit(Key var1, boolean var2) throws InvalidKeyException;

    protected final byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] tmp = new byte[this.engineGetOutputSize(inputLen)];
            int i = this.engineDoFinal(input, inputOffset, inputLen, tmp, 0);
            if (i != tmp.length) {
                byte[] t = new byte[i];
                System.arraycopy(tmp, 0, t, 0, i);
                tmp = t;
            }
            return tmp;
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
    }

    protected final int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.padding.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    protected final int engineGetBlockSize() {
        return this.padding.getBlockSize();
    }

    protected final byte[] engineGetIV() {
        return this.padding.getIV();
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new IllegalArgumentException("Key missing");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] userkey = key.getEncoded();
        if (userkey == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        return userkey.length * 8;
    }

    protected final int engineGetOutputSize(int inputLen) {
        return this.padding.getOutputSize(inputLen);
    }

    protected final AlgorithmParameters engineGetParameters() {
        AlgorithmParameterSpec aps = this.padding.getParamSpec();
        if (aps == null) {
            return null;
        }
        AlgorithmParameters ap = null;
        try {
            ap = AlgorithmParameters.getInstance(this.algorithm, "CryptixCrypto");
            ap.init(aps);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
        return ap;
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new RuntimeException("Not supported on this cipher.");
    }

    protected final void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        AlgorithmParameterSpec aps = this.padding.getParamSpec();
        try {
            this.engineInit(opmode, key, aps, random);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalError("Unreachable code reached.");
        }
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        boolean decrypt = opmode == 2;
        this.padding.init(decrypt, key, params, random);
    }

    protected final void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.mode = Mode.getInstance(mode, this);
    }

    protected final void engineSetPadding(String padding) throws NoSuchPaddingException {
        this.padding = Padding.getInstance(padding, this.mode);
    }

    protected final byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (inputLen == 0) {
            return null;
        }
        try {
            byte[] tmp = new byte[this.engineGetOutputSize(inputLen)];
            int i = this.engineUpdate(input, inputOffset, inputLen, tmp, 0);
            if (i != tmp.length) {
                byte[] t = new byte[i];
                System.arraycopy(tmp, 0, t, 0, i);
                tmp = t;
            }
            return tmp;
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("PANIC: Unreachable code reached.");
        }
    }

    protected final int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (inputLen == 0) {
            return 0;
        }
        return this.padding.update(input, inputOffset, inputLen, output, outputOffset);
    }
}

