package org.sharengo.wikitty;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UpdateResponse {
    
    protected Map<String, String> idVersionMap = new HashMap<String, String>();
    protected Map<String, Date> idDeletionDateMap = new HashMap<String, Date>();
    
    public UpdateResponse() {
        super();
        idVersionMap = new HashMap<String, String>();
    }

    /**
     * Merge all update passed in argument in local update list
     * @param update
     */
    public void add(UpdateResponse update) {
        idVersionMap.putAll(update.idVersionMap);
        idDeletionDateMap.putAll(update.idDeletionDateMap);
    }

    public void addVersionUpdate( String id, String version ) {
        idVersionMap.put(id, version);
    }

    public void addDeletionDateUpdate(String id, Date date) {
        idDeletionDateMap.put(id, date);
    }

    public void update(BusinessEntity e) {
        if (e instanceof BusinessEntityWikitty) {
            update((BusinessEntityWikitty) e);
        } else if (e instanceof BusinessEntityBean) {
            update((BusinessEntityBean) e);
        }
    }

    public void update(BusinessEntityBean e) {
        // update version
        String id = e.getWikittyId();
        String version = idVersionMap.get(id);
        if (version != null) {
            e.setWikittyVersion(version);
        }
    }

    public void update(BusinessEntityWikitty e) {
        update(e.getWikitty());
    }

    /**
     * Update data directly in object passed in argument.
     * Actualy only version and deletion date are updated.
     * And internaly wikitty object is marked clean (not dirty)
     * @param e
     */
    public void update(Wikitty e) {
        // update version
        String id = e.getId();
        String version = idVersionMap.get(id);
        if (version != null) {
            e.setVersion(version);
        }
        Date date = idDeletionDateMap.get(id);
        if (date != null) {
            e.setDeleteDate(date);
        }
        e.clearDirty();
    }

}
