/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nuiton.wikitty.ui;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.event.ListDataEvent;

/**
 *
 * @author sherkhan
 */
public class FormModel extends AbstractListModel implements BindingListModel {

    protected List<FieldExtension> _fieldExtensions = new ArrayList<FieldExtension>();

    @Override
    public Object getElementAt(int index) {
        return _fieldExtensions.get(index);
    }

    @Override
    public int getSize() {
        return _fieldExtensions.size();
    }

    @Override
    public int indexOf(Object obj) {
        return _fieldExtensions.indexOf(obj);
    }

    public void setFieldExtensions(List<FieldExtension> fieldExtensions) {
        _fieldExtensions = fieldExtensions;
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }

    public void addData(FieldExtension newData) {
        _fieldExtensions.add(newData);
        fireEvent(ListDataEvent.INTERVAL_ADDED, _fieldExtensions.size() - 1, _fieldExtensions.size() - 1);
    }

    public void removeData(FieldExtension data) {
        int interval = _fieldExtensions.indexOf(data);
        _fieldExtensions.remove(data);
        fireEvent(ListDataEvent.INTERVAL_REMOVED, interval, interval);
    }

    public void reload() {
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }
}
