/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.struts;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.struts.ExtensionFieldStrutsBean;

public class WikittyFieldHandler {
    private static final Log log = LogFactory.getLog(WikittyFieldHandler.class);
    public static String ALL_EXTENSION_CAR = "*";
    public static String FIELD_SEPARATOR = ",";
    protected String wikittyId;
    protected Wikitty wikitty;
    protected BusinessEntity businessEntity;
    protected WikittyProxy proxy;
    protected String include = "";
    protected String exclude = "";
    protected String order = "";
    protected Boolean orderBefore = false;
    protected Set<String> fieldAdded = new HashSet<String>();
    protected Map<String, List<String>> excludeMap;
    protected Map<String, List<String>> includeMap;
    protected boolean includeEnable = false;
    public static final String WIKITTY_STACK_KEY = "wikitty_key";

    public Set<String> getFieldAdded() {
        return this.fieldAdded;
    }

    public void setFieldAdded(Set<String> fieldAdded) {
        this.fieldAdded = fieldAdded;
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public Wikitty getWikitty() {
        if (this.wikitty == null) {
            this.wikitty = StringUtils.isNotEmpty((CharSequence)this.wikittyId) ? this.getProxy().restore(this.wikittyId) : ((BusinessEntityImpl)this.getBusinessEntity()).getWikitty();
        }
        return this.wikitty;
    }

    public void setWikitty(Wikitty wikitty) {
        this.wikitty = wikitty;
    }

    public BusinessEntity getBusinessEntity() {
        return this.businessEntity;
    }

    public void setBusinessEntity(BusinessEntity businessEntity) {
        this.businessEntity = businessEntity;
    }

    public Boolean getOrderBefore() {
        return this.orderBefore;
    }

    public void setOrderBefore(Boolean orderBefore) {
        this.orderBefore = orderBefore;
    }

    public WikittyProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(WikittyProxy proxy) {
        this.proxy = proxy;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
        this.includeMap = this.constructIncludeExcludeMap(include);
        this.includeEnable = this.includeMap.size() != 0;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
        this.excludeMap = this.constructIncludeExcludeMap(exclude);
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public Collection<ExtensionFieldStrutsBean> getWikittyField() {
        if (this.orderBefore.booleanValue() && this.fieldAdded.size() == 0) {
            return this.getFieldOrderedBefore();
        }
        HashMap<String, ExtensionFieldStrutsBean> mapField = new HashMap<String, ExtensionFieldStrutsBean>();
        for (WikittyExtension ext : this.getWikitty().getExtensions()) {
            String extName = ext.getName();
            if (!this.isIncluded(extName, ALL_EXTENSION_CAR)) continue;
            for (String fieldName : ext.getFieldNames()) {
                if (!this.isIncluded(extName, fieldName)) continue;
                ExtensionFieldStrutsBean temp = this.constructExtensionFieldFromField(extName, fieldName);
                log.debug((Object)("Add field : " + temp));
                mapField.put(temp.getName(), temp);
            }
        }
        String[] fieldOrder = StringUtil.split((String)this.order, (String)FIELD_SEPARATOR);
        Collection<ExtensionFieldStrutsBean> result = mapField.values();
        if (fieldOrder.length != 0 && !this.orderBefore.booleanValue()) {
            LinkedList<ExtensionFieldStrutsBean> orderedResult = new LinkedList<ExtensionFieldStrutsBean>();
            for (String orderIt : fieldOrder) {
                if (!mapField.containsKey(orderIt)) continue;
                orderedResult.add((ExtensionFieldStrutsBean)mapField.remove(orderIt));
            }
            orderedResult.addAll(mapField.values());
            result = orderedResult;
        }
        return result;
    }

    protected Collection<ExtensionFieldStrutsBean> getFieldOrderedBefore() {
        LinkedList<ExtensionFieldStrutsBean> result = new LinkedList<ExtensionFieldStrutsBean>();
        this.fieldAdded.add("DUMMY");
        log.debug((Object)("orderBefore enable with" + this.order));
        String[] fieldOrder = StringUtil.split((String)this.order, (String)FIELD_SEPARATOR);
        if (fieldOrder.length != 0) {
            for (String fieldit : fieldOrder) {
                if (!this.isIncluded(fieldit)) continue;
                String extname = WikittyUtil.getExtensionNameFromFQFieldName((String)fieldit);
                String field = WikittyUtil.getFieldNameFromFQFieldName((String)fieldit);
                if ("*".equals(field)) {
                    WikittyExtension ext = this.getWikitty().getExtension(extname);
                    for (String fieldNameIt : ext.getFieldNames()) {
                        ExtensionFieldStrutsBean temp = this.constructExtensionFieldFromField(extname, fieldNameIt);
                        result.add(temp);
                        this.fieldAdded.add(temp.getName());
                    }
                    continue;
                }
                ExtensionFieldStrutsBean temp = this.constructExtensionFieldFromField(extname, field);
                result.add(temp);
                this.fieldAdded.add(temp.getName());
            }
        }
        return result;
    }

    protected Map<String, List<String>> constructIncludeExcludeMap(String entry) {
        String[] entryTab = StringUtil.split((String)entry, (String)FIELD_SEPARATOR);
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String excludeIt : entryTab) {
            String[] extfield = StringUtil.split((String)(excludeIt = excludeIt.trim()), (String)".");
            if (extfield.length != 2) continue;
            LinkedList<String> listFields = (LinkedList<String>)result.get(extfield[0]);
            if (listFields == null) {
                listFields = new LinkedList<String>();
            }
            listFields.add(extfield[1]);
            result.put(extfield[0], listFields);
        }
        return result;
    }

    public void addAddedField(String field) {
        log.debug((Object)("Field added : " + field));
        this.fieldAdded.add(field);
    }

    public boolean isIncluded(String fqFieldName) {
        String extName = WikittyUtil.getExtensionNameFromFQFieldName((String)fqFieldName);
        String fieldName = WikittyUtil.getFieldNameFromFQFieldName((String)fqFieldName);
        return this.isIncluded(extName, fieldName);
    }

    public boolean isIncluded(String extName, String fieldName) {
        boolean excluded = this.excludeMap.containsKey(extName) && (this.excludeMap.get(extName).contains(ALL_EXTENSION_CAR) || this.excludeMap.get(extName).contains(fieldName));
        boolean notIncluded = this.includeEnable && (!this.includeMap.containsKey(extName) || !this.includeMap.get(extName).contains(ALL_EXTENSION_CAR) && !this.includeMap.get(extName).contains(fieldName));
        boolean added = this.fieldAdded.contains(extName + "." + fieldName);
        log.debug((Object)("extension: " + extName + "." + fieldName + " - notInclude:" + notIncluded + " exclude:" + excluded + " alreadyAdd:" + added));
        return !excluded && !notIncluded && !added;
    }

    protected ExtensionFieldStrutsBean constructExtensionFieldFromField(String extName, String fieldName) {
        ExtensionFieldStrutsBean result = new ExtensionFieldStrutsBean();
        FieldType fieldType = this.wikitty.getExtension(extName).getFieldType(fieldName);
        result.setName(extName + "." + fieldName);
        result.setLabel(result.getName());
        result.setValue("");
        switch (fieldType.getType()) {
            case BINARY: {
                result.setType("file");
                break;
            }
            case BOOLEAN: {
                boolean valueBool = this.getWikitty().getFieldAsBoolean(extName, fieldName);
                result.setType("boolean");
                result.setValue(valueBool);
                break;
            }
            default: {
                Object valueObject = this.getWikitty().getFieldAsObject(extName, fieldName);
                String valueString = "";
                if (valueObject != null) {
                    valueString = String.valueOf(valueObject);
                }
                result.setValue(valueString);
                valueString = StringEscapeUtils.escapeHtml4((String)valueString);
                if (valueString.contains("\n") || "true".equals(fieldType.getTagValue("multiline"))) {
                    result.setType("textarea");
                    break;
                }
                result.setType("textfield");
            }
        }
        return result;
    }
}

