/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.publication.WikittyPublicationFileSystem;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikittyPublication {
    private static final Log log = LogFactory.getLog(WikittyPublication.class);
    protected static ApplicationConfig applicationConfig;
    public static String WITTY_SERVICE_KEY;
    public static String NO_RECURSION_KEY;
    public static String DIRECTORY_KEY;
    public static String HESSIAN_PROTOCOL_KEY;
    public static String DEFAULT_PROPERTY_NAME_SEP;
    public static String PROPERTY_DIRECTORY;
    public static String WIKITTYPUBLICATION_PROPERTIES_FILE;
    public static String WIKITTY_ID_PROPERTIES_FILE;
    public static String WIKITTY_FILE_META_PROPERTIES_FILE;
    public static String META_SUFFIX_KEY_VERSION;
    public static String META_SUFFIX_KEY_CHECKSUM;
    public static String META_SUFFIX_KEY_ID;
    public static String META_CURRENT_LABEL;
    public static String META_SUB_LABEL;

    public static void main(String[] args) throws Exception {
        applicationConfig = new ApplicationConfig();
        applicationConfig.addAlias("--ws", new String[]{"--option", WITTY_SERVICE_KEY});
        applicationConfig.addAlias("--dir", new String[]{"--option", DIRECTORY_KEY});
        applicationConfig.addAlias("--norecursion", new String[]{"--option", NO_RECURSION_KEY, "true"});
        applicationConfig.addAlias("--hessian", new String[]{"--option", HESSIAN_PROTOCOL_KEY, "true"});
        applicationConfig.addAlias("wp import", new String[]{"--option", "import"});
        applicationConfig.addAlias("wp checkout", new String[]{"--option", "checkout"});
        applicationConfig.addAlias("wp relocate", new String[]{"--option", "relocate"});
        applicationConfig.addAlias("wp commit", new String[]{"--option", "commit"});
        applicationConfig.addAlias("wp delete", new String[]{"--option", "delete"});
        applicationConfig.addAlias("wp update", new String[]{"--option", "update"});
        applicationConfig.addActionAlias("import", "org.nuiton.wikitty.publication.WikittyPublication#importToWikitty");
        applicationConfig.addActionAlias("checkout", "org.nuiton.wikitty.publication.WikittyPublication#checkoutFromWikitty");
        applicationConfig.addActionAlias("relocate", "org.nuiton.wikitty.publication.WikittyPublication#relocateWikitty");
        applicationConfig.addActionAlias("commit", "org.nuiton.wikitty.publication.WikittyPublication#commitToWikitty");
        applicationConfig.addActionAlias("delete", "org.nuiton.wikitty.publication.WikittyPublication#deleteFromWikitty");
        applicationConfig.addActionAlias("update", "org.nuiton.wikitty.publication.WikittyPublication#updateFromWikitty");
        applicationConfig.parse(args);
        applicationConfig.doAction(0);
    }

    public static void importToWikitty() throws Exception {
        boolean noRecur = applicationConfig.getOptionAsBoolean(NO_RECURSION_KEY);
        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);
        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
        log.info((Object)("import : wikittyservice: " + wikittyService + " noresursion=" + noRecur + " directory= " + dir.getAbsolutePath()));
        applicationConfig.setOption("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceCajoClient");
        System.out.println(applicationConfig.getOption("wikitty.service.server.url"));
        WikittyProxy remoteWikittyService = new WikittyProxy(WikittyServiceFactory.buildWikittyService((ApplicationConfig)applicationConfig));
        List toTransfert = WikittyPublication.listFile((File)dir, (!noRecur ? 1 : 0) != 0);
        ArrayList<Wikitty> listWikitty = new ArrayList<Wikitty>();
        for (File fileToTransform : toTransfert) {
            listWikitty.add(WikittyPublicationFileSystem.fileToWikitty((File)fileToTransform, (File)dir));
        }
        remoteWikittyService.storeWikitty(listWikitty);
    }

    public static void printDirectory(File dir, boolean recur) {
        System.out.println("<dir " + dir.getName() + ">");
        for (File child : dir.listFiles()) {
            if (child.isDirectory() && recur && !child.getName().equals(PROPERTY_DIRECTORY)) {
                WikittyPublication.printDirectory((File)child, (boolean)recur);
                continue;
            }
            if (child.isDirectory()) continue;
            System.out.println(child.getAbsolutePath());
        }
        System.out.println("</dir " + dir.getName() + ">");
    }

    protected static List<File> listFile(File starts, boolean recursivly) {
        ArrayList<File> result = new ArrayList<File>();
        if (!starts.isDirectory()) {
            result.add(starts);
        }
        for (File child : starts.listFiles()) {
            if (child.isDirectory() && recursivly && !child.getName().equals(PROPERTY_DIRECTORY)) {
                result.addAll(WikittyPublication.listFile((File)child, (boolean)recursivly));
                continue;
            }
            if (child.isDirectory()) continue;
            result.add(child);
        }
        return result;
    }

    public static void checkoutFromWikitty(String label) throws Exception {
        boolean noRecur = applicationConfig.getOptionAsBoolean(NO_RECURSION_KEY);
        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);
        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
        boolean hessianProtocole = applicationConfig.getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);
        log.info((Object)("checkout : wikittyservice: " + wikittyService + " noresursion=" + noRecur + " directory= " + dir.getAbsolutePath() + "Label a checkout " + label + "HessianProtocol=" + hessianProtocole));
        WikittyProxy remoteWikittyService = new WikittyProxy(WikittyServiceFactory.buildWikittyService((ApplicationConfig)applicationConfig));
        WikittyPublicationFileSystem localWikittyService = new WikittyPublicationFileSystem(dir);
        Search mainRequest = Search.query();
        Search subRoqu = mainRequest.or();
        subRoqu.exteq("WikittyPubText").exteq("WikittyPubData");
        Criteria labelCriteria = noRecur ? mainRequest.exteq("WikittyLabel").eq("WikittyLabel.labels", label).criteria() : mainRequest.exteq("WikittyLabel").sw("WikittyLabel.labels", label).criteria();
        List wikittiesToWrite = remoteWikittyService.findAllByCriteria(labelCriteria).getAll();
        localWikittyService.store("", (Collection)wikittiesToWrite, true);
        Properties props = new Properties();
        props.put(WITTY_SERVICE_KEY, wikittyService);
        if (hessianProtocole) {
            props.put("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceHessianClient");
        } else {
            props.put("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceCajoClient");
        }
        File wpDirectory = new File(dir.getCanonicalPath() + File.separator + PROPERTY_DIRECTORY + File.separator);
        if (!wpDirectory.exists()) {
            wpDirectory.createNewFile();
        }
        File propertiesFiles = new File(wpDirectory.getCanonicalPath() + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);
        props.store(new FileWriter(propertiesFiles), "");
    }

    public static void relocateWikitty() throws Exception {
        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);
        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
        boolean hessianProtocole = applicationConfig.getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);
        System.out.println("search the directory of .wp file to write new properties file");
        File wpHomeDir = null == dir || !dir.exists() ? WikittyPublication.searchWikittyPublicationHomeDir((File)new File(".")) : new File(dir.getCanonicalFile() + File.separator + PROPERTY_DIRECTORY);
        Properties oldProperties = new Properties();
        File propertiesFile = new File(wpHomeDir + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);
        oldProperties.load(new FileReader(propertiesFile));
        log.info((Object)("Try relocate :wikitty service:" + oldProperties.getProperty(WITTY_SERVICE_KEY) + " by " + wikittyService + " HessianProtocol: " + hessianProtocole + " File : " + propertiesFile.getCanonicalPath()));
        Properties props = new Properties();
        props.put(WITTY_SERVICE_KEY, wikittyService);
        if (hessianProtocole) {
            props.put("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceHessianClient");
        } else {
            props.put("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceCajoClient");
        }
        props.store(new FileWriter(propertiesFile), "");
    }

    public static void commitToWikitty() throws Exception {
        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);
        if (null == dir || !dir.exists()) {
            dir = new File(".");
        }
        File wpHomeDir = WikittyPublication.searchWikittyPublicationHomeDir((File)dir);
        Properties properties = new Properties();
        File propertiesFile = new File(wpHomeDir.getCanonicalPath() + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);
        properties.load(new FileReader(propertiesFile));
        applicationConfig.setOptions(properties);
        boolean noRecur = applicationConfig.getOptionAsBoolean(NO_RECURSION_KEY);
        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
        boolean hessianProtocole = applicationConfig.getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);
        if (hessianProtocole) {
            applicationConfig.setOption("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceHessianClient");
        } else {
            applicationConfig.setOption("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceCajoClient");
        }
        log.info((Object)("commit  wikitty-service" + wikittyService + "noRecurs : " + noRecur + " hessian Protocole :" + hessianProtocole + "directory : " + dir.getAbsolutePath()));
        System.out.println("try to commit: ");
        WikittyPublication.printDirectory((File)dir, (!noRecur ? 1 : 0) != 0);
    }

    public static void deleteFromWikitty(File toDelete) throws Exception {
        if (null != toDelete && toDelete.exists()) {
            File wpHomeDir = WikittyPublication.searchWikittyPublicationHomeDir((File)new File("."));
            File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);
            wpHomeDir = WikittyPublication.searchWikittyPublicationHomeDir((File)dir);
            Properties properties = new Properties();
            File propertiesFile = new File(wpHomeDir.getCanonicalPath() + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);
            properties.load(new FileReader(propertiesFile));
            applicationConfig.setOptions(properties);
            String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
            boolean hessianProtocole = applicationConfig.getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);
            if (hessianProtocole) {
                applicationConfig.setOption("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceHessianClient");
            } else {
                applicationConfig.setOption("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceCajoClient");
            }
            log.info((Object)("Delete  wikitty-service" + wikittyService + " hessian Protocole :" + hessianProtocole + "file to delete : " + toDelete.getAbsolutePath()));
            System.out.println("try to delete: ");
            WikittyPublication.printDirectory((File)dir, (boolean)true);
        }
    }

    public static void updateFromWikitty() throws Exception {
        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);
        if (null == dir || !dir.exists()) {
            dir = new File(".");
        }
        File wpHomeDir = WikittyPublication.searchWikittyPublicationHomeDir((File)dir);
        Properties properties = new Properties();
        File propertiesFile = new File(wpHomeDir.getCanonicalPath() + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);
        properties.load(new FileReader(propertiesFile));
        applicationConfig.setOptions(properties);
        boolean noRecur = applicationConfig.getOptionAsBoolean(NO_RECURSION_KEY);
        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
        boolean hessianProtocole = applicationConfig.getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);
        if (hessianProtocole) {
            applicationConfig.setOption("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceHessianClient");
        } else {
            applicationConfig.setOption("wikitty.WikittyService.components", "org.nuiton.wikitty.services.WikittyServiceCajoClient");
        }
        log.info((Object)("update  wikitty-service" + wikittyService + "noRecurs : " + noRecur + " hessian Protocole :" + hessianProtocole + "directory : " + dir.getAbsolutePath()));
        System.out.println("try to update: ");
        WikittyPublication.printDirectory((File)dir, (!noRecur ? 1 : 0) != 0);
    }

    protected static File searchWikittyPublicationHomeDir(File start) throws Exception {
        if (start != null && start.exists() && start.isDirectory()) {
            File propertie;
            File propertyDirectory = new File(start.getCanonicalPath() + File.separator + PROPERTY_DIRECTORY);
            if (propertyDirectory.exists() && (propertie = new File(propertyDirectory.getCanonicalPath() + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE)).exists()) {
                return propertyDirectory;
            }
            return WikittyPublication.searchWikittyPublicationHomeDir((File)start.getParentFile());
        }
        return null;
    }

    protected static HashMap<String, String> deleteFile(File toDelete) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String pathToProperty = toDelete.getCanonicalFile() + File.separator + PROPERTY_DIRECTORY + File.separator;
        File metaFile = new File(pathToProperty + WIKITTY_FILE_META_PROPERTIES_FILE);
        Properties metaProperties = new Properties();
        metaProperties.load(new FileReader(metaFile));
        File idFile = new File(pathToProperty + WIKITTY_ID_PROPERTIES_FILE);
        Properties idProperties = new Properties();
        idProperties.load(new FileReader(idFile));
        if (toDelete.isDirectory()) {
            for (File child : toDelete.listFiles()) {
                if (!child.isDirectory() || child.getName().equals(PROPERTY_DIRECTORY)) continue;
                result.putAll(WikittyPublication.deleteFile((File)child));
            }
            String[] currents = StringUtil.split((String)metaProperties.getProperty(META_SUB_LABEL), (String)",");
            ArrayList<String> subLabel = new ArrayList<String>();
            for (String sub : currents) {
                if (sub.endsWith(toDelete.getName())) continue;
                subLabel.add(sub);
            }
            String subLabelResult = StringUtil.join(subLabel, (String)",", (boolean)true);
            metaProperties.put(META_SUB_LABEL, subLabelResult);
        } else {
            String id = metaProperties.getProperty(toDelete.getName() + DEFAULT_PROPERTY_NAME_SEP + META_SUFFIX_KEY_ID);
            String label = metaProperties.getProperty(META_CURRENT_LABEL);
            result.put(id, label);
            idProperties.remove(id);
            metaProperties.remove(toDelete.getName() + DEFAULT_PROPERTY_NAME_SEP + META_SUFFIX_KEY_ID);
            metaProperties.remove(toDelete.getName() + DEFAULT_PROPERTY_NAME_SEP + META_SUFFIX_KEY_CHECKSUM);
            metaProperties.remove(toDelete.getName() + DEFAULT_PROPERTY_NAME_SEP + META_SUFFIX_KEY_VERSION);
        }
        metaProperties.store(new FileWriter(metaFile), "");
        idProperties.store(new FileWriter(idFile), "");
        toDelete.delete();
        return result;
    }

    static {
        WITTY_SERVICE_KEY = "wikitty.service.server.url";
        NO_RECURSION_KEY = "norecursion";
        DIRECTORY_KEY = "directory";
        HESSIAN_PROTOCOL_KEY = "hessian";
        DEFAULT_PROPERTY_NAME_SEP = ".";
        PROPERTY_DIRECTORY = ".wp";
        WIKITTYPUBLICATION_PROPERTIES_FILE = "ws.properties";
        WIKITTY_ID_PROPERTIES_FILE = "ids.properties";
        WIKITTY_FILE_META_PROPERTIES_FILE = "meta.properties";
        META_SUFFIX_KEY_VERSION = "version";
        META_SUFFIX_KEY_CHECKSUM = "checksum";
        META_SUFFIX_KEY_ID = "id";
        META_CURRENT_LABEL = "current.label";
        META_SUB_LABEL = "sub.label";
    }
}

