/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.publication.AbstractAction;
import org.nuiton.wikitty.publication.WikittyPublicationContext;
import org.nuiton.wikitty.publication.entities.WikittyPubDataHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubTextHelper;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

public abstract class AbstractActionOnWikitty
extends AbstractAction {
    private static Log log = LogFactory.getLog(AbstractActionOnWikitty.class);
    public static final int ARG_QUERY = 0;
    public static final String ARG_MIMETYPE = "mimetype";
    public static final String ARG_CONTENT_FIELD = "contentField";
    public static final String SEARCH_SEPARATOR = ":";

    protected abstract String getExampleUsage();

    protected String getMimeType(WikittyPublicationContext context, String name, Wikitty w) {
        String mimetype = context.getArgument("mimetype:" + name, null);
        if (mimetype == null) {
            mimetype = context.getArgument(ARG_MIMETYPE, null);
        }
        if (mimetype != null) {
            String fieldName;
            String extName;
            int i = mimetype.indexOf(".");
            if (i > 0 && w.hasField(extName = WikittyExtension.extractExtensionName((String)mimetype), fieldName = WikittyExtension.extractFieldName((String)mimetype))) {
                mimetype = w.getFieldAsString(extName, fieldName);
            }
        } else if (w.hasExtension("WikittyPubText")) {
            mimetype = WikittyPubTextHelper.getMimeType((Wikitty)w);
        } else if (w.hasExtension("WikittyPubData")) {
            mimetype = WikittyPubDataHelper.getMimeType((Wikitty)w);
        }
        return mimetype;
    }

    protected Criteria searchCriteria(List<String> subContext) {
        Criteria result;
        if (subContext.size() <= 0) {
            result = null;
        } else {
            String searchString = subContext.get(0);
            if (searchString.contains(SEARCH_SEPARATOR)) {
                String[] arg = searchString.split(SEARCH_SEPARATOR);
                result = Search.query().eq(arg[0], arg[1]).criteria(searchString);
            } else {
                result = Search.query().or().eq("WikittyPubText.name", searchString).eq("WikittyPubData.name", searchString).criteria(searchString);
            }
        }
        return result;
    }

    protected String getContentFieldName(WikittyPublicationContext context, String name, Wikitty w) {
        String contentField = context.getArgument("contentField:" + name, null);
        if (contentField == null) {
            contentField = context.getArgument(ARG_CONTENT_FIELD, null);
        }
        if (contentField == null) {
            if (w.hasExtension("WikittyPubText")) {
                contentField = "WikittyPubText.content";
            } else if (w.hasExtension("WikittyPubData")) {
                contentField = "WikittyPubData.content";
            }
        }
        return contentField;
    }

    protected String getError(WikittyPublicationContext context) {
        context.setContentType("text/html");
        String result = String.format("<h1>bad query %s</h1>Usage example<pre>%s</pre>", context.getRequest().getPathInfo(), this.getExampleUsage());
        return result;
    }
}

