/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.tapestry5.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.services.BindingFactory;
import org.apache.tapestry5.services.BindingSource;
import org.nuiton.web.tapestry5.services.FormatBinding;

public class FormatBindingFactory
implements BindingFactory {
    private static final String SEPARATOR = "=";
    private static final String DELIMITER = ",";
    private static final String KEY_PREFIX = "literal";
    private static final String VALUE_PREFIX = "prop";
    private final BindingSource bindingSource;

    public FormatBindingFactory(BindingSource bindingSource) {
        this.bindingSource = bindingSource;
    }

    public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
        int separatorIndex = expression.indexOf(SEPARATOR);
        if (-1 == separatorIndex) {
            List<String> keys = Arrays.asList(expression.split(DELIMITER));
            ArrayList<Binding> keyBindings = this.createBindings(description, container, component, KEY_PREFIX, keys, location);
            boolean invariant = this.isInvariant(keyBindings);
            return new FormatBinding(location, container.getMessages(), invariant, keyBindings);
        }
        List<String> keys = Arrays.asList(expression.substring(0, separatorIndex).split(DELIMITER));
        ArrayList<Binding> keyBindings = this.createBindings(description, container, component, KEY_PREFIX, keys, location);
        List<String> values = Arrays.asList(expression.substring(separatorIndex + 1).split(DELIMITER));
        ArrayList<Binding> valueBindings = this.createBindings(description, container, component, VALUE_PREFIX, values, location);
        boolean invariant = this.isInvariant(keyBindings) && this.isInvariant(valueBindings);
        return new FormatBinding(location, container.getMessages(), invariant, keyBindings, valueBindings);
    }

    private ArrayList<Binding> createBindings(String description, ComponentResources container, ComponentResources component, String defaultPrefix, List<String> expressions, Location location) {
        ArrayList<Binding> bindings = new ArrayList<Binding>(expressions.size());
        for (String expression : expressions) {
            bindings.add(this.bindingSource.newBinding(description, container, component, defaultPrefix, expression, location));
        }
        return bindings;
    }

    private boolean isInvariant(ArrayList<Binding> bindings) {
        for (Binding binding : bindings) {
            if (binding.isInvariant()) continue;
            return false;
        }
        return true;
    }
}

