package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Fri Jul 04 16:02:50 CEST 2014")
public abstract class TopiaGroupAbstract extends TopiaEntityAbstract implements TopiaGroup {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : description
     */
    protected String description;

    /**
     * Nom de l'attribut en BD : topiaUser
     */
    protected Collection<TopiaUser> topiaUser;

    /**
     * Nom de l'attribut en BD : superGroup
     */
    protected TopiaGroup superGroup;

    /**
     * Nom de l'attribut en BD : subGroup
     */
    protected Collection<TopiaGroup> subGroup;

    private static final long serialVersionUID = 3832957145137229921L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, DESCRIPTION, String.class, description);
        visitor.visit(this, TOPIA_USER, Collection.class, TopiaUser.class, topiaUser);
        visitor.visit(this, SUPER_GROUP, TopiaGroup.class, superGroup);
        visitor.visit(this, SUB_GROUP, Collection.class, TopiaGroup.class, subGroup);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(NAME, name);

        String result = this.name;

        fireOnPostRead(NAME, name);

        return result;
    }

    @Override
    public void setDescription(String description) {
        String oldValue = this.description;
        fireOnPreWrite(DESCRIPTION, oldValue, description);
        this.description = description;
        fireOnPostWrite(DESCRIPTION, oldValue, description);
    }

    @Override
    public String getDescription() {
        fireOnPreRead(DESCRIPTION, description);

        String result = this.description;

        fireOnPostRead(DESCRIPTION, description);

        return result;
    }

    @Override
    public void addTopiaUser(TopiaUser topiaUser) {
        fireOnPreWrite(TOPIA_USER, null, topiaUser);
        if (this.topiaUser == null) {
            this.topiaUser = new ArrayList<TopiaUser>();
        }

        if (topiaUser.getTopiaGroup() == null) {
            topiaUser.setTopiaGroup(new ArrayList<TopiaGroup>());
        }
        topiaUser.getTopiaGroup().add(this);

        this.topiaUser.add(topiaUser);
        fireOnPostWrite(TOPIA_USER, this.topiaUser.size(), null, topiaUser);
    }

    @Override
    public void addAllTopiaUser(Collection<TopiaUser> topiaUser) {
        if (topiaUser == null) {
            return;
        }
        for (TopiaUser item : topiaUser) {
            addTopiaUser(item);
        }
    }

    @Override
    public void setTopiaUser(Collection<TopiaUser> topiaUser) {
        // Copy elements to keep data for fire with new reference
        Collection<TopiaUser> oldValue = this.topiaUser != null ? new ArrayList<TopiaUser>(this.topiaUser) : null;
        fireOnPreWrite(TOPIA_USER, oldValue, topiaUser);
        this.topiaUser = topiaUser;
        fireOnPostWrite(TOPIA_USER, oldValue, topiaUser);
    }

    @Override
    public void removeTopiaUser(TopiaUser topiaUser) {
        fireOnPreWrite(TOPIA_USER, topiaUser, null);
        if (this.topiaUser == null || !this.topiaUser.remove(topiaUser)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        topiaUser.getTopiaGroup().remove(this);

        fireOnPostWrite(TOPIA_USER, this.topiaUser.size() + 1, topiaUser, null);
    }

    @Override
    public void clearTopiaUser() {
        if (this.topiaUser == null) {
            return;
        }
        for (TopiaUser item : this.topiaUser) {
            item.getTopiaGroup().remove(this);
        }
        Collection<TopiaUser> oldValue = new ArrayList<TopiaUser>(this.topiaUser);
        fireOnPreWrite(TOPIA_USER, oldValue, this.topiaUser);
        this.topiaUser.clear();
        fireOnPostWrite(TOPIA_USER, oldValue, this.topiaUser);
    }

    @Override
    public Collection<TopiaUser> getTopiaUser() {
        return topiaUser;
    }

    @Override
    public TopiaUser getTopiaUserByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(topiaUser, topiaId);
    }

    @Override
    public int sizeTopiaUser() {
        if (topiaUser == null) {
            return 0;
        }
        return topiaUser.size();
    }

    @Override
    public boolean isTopiaUserEmpty() {
        int size = sizeTopiaUser();
        return size == 0;
    }

    @Override
    public void setSuperGroup(TopiaGroup superGroup) {
        TopiaGroup oldValue = this.superGroup;
        fireOnPreWrite(SUPER_GROUP, oldValue, superGroup);
        this.superGroup = superGroup;
        fireOnPostWrite(SUPER_GROUP, oldValue, superGroup);
    }

    @Override
    public TopiaGroup getSuperGroup() {
        fireOnPreRead(SUPER_GROUP, superGroup);

        TopiaGroup result = this.superGroup;

        fireOnPostRead(SUPER_GROUP, superGroup);

        return result;
    }

    @Override
    public void addSubGroup(TopiaGroup subGroup) {
        fireOnPreWrite(SUB_GROUP, null, subGroup);
        if (this.subGroup == null) {
            this.subGroup = new ArrayList<TopiaGroup>();
        }

        subGroup.setSuperGroup(this);

        this.subGroup.add(subGroup);
        fireOnPostWrite(SUB_GROUP, this.subGroup.size(), null, subGroup);
    }

    @Override
    public void addAllSubGroup(Collection<TopiaGroup> subGroup) {
        if (subGroup == null) {
            return;
        }
        for (TopiaGroup item : subGroup) {
            addSubGroup(item);
        }
    }

    @Override
    public void setSubGroup(Collection<TopiaGroup> subGroup) {
        // Copy elements to keep data for fire with new reference
        Collection<TopiaGroup> oldValue = this.subGroup != null ? new ArrayList<TopiaGroup>(this.subGroup) : null;
        fireOnPreWrite(SUB_GROUP, oldValue, subGroup);
        this.subGroup = subGroup;
        fireOnPostWrite(SUB_GROUP, oldValue, subGroup);
    }

    @Override
    public void removeSubGroup(TopiaGroup subGroup) {
        fireOnPreWrite(SUB_GROUP, subGroup, null);
        if (this.subGroup == null || !this.subGroup.remove(subGroup)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        subGroup.setSuperGroup(null);

        fireOnPostWrite(SUB_GROUP, this.subGroup.size() + 1, subGroup, null);
    }

    @Override
    public void clearSubGroup() {
        if (this.subGroup == null) {
            return;
        }
        for (TopiaGroup item : this.subGroup) {
            item.setSuperGroup(null);
        }
        Collection<TopiaGroup> oldValue = new ArrayList<TopiaGroup>(this.subGroup);
        fireOnPreWrite(SUB_GROUP, oldValue, this.subGroup);
        this.subGroup.clear();
        fireOnPostWrite(SUB_GROUP, oldValue, this.subGroup);
    }

    @Override
    public Collection<TopiaGroup> getSubGroup() {
        return subGroup;
    }

    @Override
    public TopiaGroup getSubGroupByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(subGroup, topiaId);
    }

    @Override
    public int sizeSubGroup() {
        if (subGroup == null) {
            return 0;
        }
        return subGroup.size();
    }

    @Override
    public boolean isSubGroupEmpty() {
        int size = sizeSubGroup();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(DESCRIPTION, this.description).
         toString();
        return result;
    }

} //TopiaGroupAbstract
