/*
 * #%L
 * ToPIA :: Service Security
 * 
 * $Id: TaasCallbackHandler.java 2245 2011-04-14 12:47:09Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.6.6/topia-service-security/src/main/java/org/nuiton/topia/taas/jaas/TaasCallbackHandler.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * TopiaCallbackHandler.java
 *
 * Created: 20 févr. 2006
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 * @version $Revision: 2245 $
 *
 * Mise a jour: $Date: 2011-04-14 14:47:09 +0200 (jeu, 14 avr 2011) $
 * par : */

package org.nuiton.topia.taas.jaas;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/**
 * Classe permettant l'interfaçage entre l'application et la sécurité.
 * @author ruchaud
 */
public class TaasCallbackHandler implements CallbackHandler {

    private String username;

    private String password;

    /**
     * Contructeur
     * @param username login de l'utilisateur
     * @param password mot de passe de l'utilisateur
     */
    public TaasCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.security.auth.callback.CallbackHandler#handle(javax.security.auth.callback.Callback[])
     */
    public void handle(Callback[] callbacks) throws IOException,
            UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback) callback;
                nc.setName(username);
            } else if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback) callback;
                pc.setPassword(password.toCharArray());
            } else
                throw new UnsupportedCallbackException(callback);
        }
    }

}
