/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas.event;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.event.TopiaEntitiesEvent;
import org.nuiton.topia.event.TopiaEntityEvent;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.topia.taas.event.TaasAccessEntity;

public class TaasEntityVetoableRequestPermission
implements TaasAccessEntity {
    private static Log log = LogFactory.getLog(TaasEntityVetoableRequestPermission.class);
    protected TaasService taasService;

    public TaasEntityVetoableRequestPermission(TaasService taasService) {
        this.taasService = taasService;
    }

    public void create(TopiaEntityEvent event) {
        TopiaEntity entity = event.getEntity();
        String topiaId = entity.getTopiaId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Security] create entity : " + topiaId));
        }
        this.taasService.checkRequestPermission(entity, 2);
    }

    public void delete(TopiaEntityEvent event) {
        TopiaEntity entity = event.getEntity();
        String topiaId = entity.getTopiaId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Security] delete entity : " + topiaId));
        }
        this.taasService.checkRequestPermission(entity, 8);
    }

    public void load(TopiaEntityEvent event) {
    }

    public void update(TopiaEntityEvent event) {
        TopiaEntity entity = event.getEntity();
        String topiaId = entity.getTopiaId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Security] update entity : " + topiaId));
        }
        this.taasService.checkRequestPermission(entity, 4);
    }

    public <E extends TopiaEntity> List<E> load(TopiaEntitiesEvent<E> event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"[Security] load entities");
        }
        List entities = event.getEntities();
        this.taasService.checkRequestPermission(entities, 1);
        return entities;
    }
}

