package org.nuiton.topia.taas.entities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link TaasPrincipal}.
 */
public abstract class TaasPrincipalAbstract extends TopiaEntityAbstract implements TaasPrincipal {

    protected String name;

    public Collection<TaasAuthorization> authorizations;

    /**
     * Constructeur de TaasPrincipalAbstract par défaut.
     */
    public TaasPrincipalAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasPrincipal.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasPrincipal.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "authorizations", Collection.class, TaasAuthorization.class, authorizations);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#setName(String)
     */
    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#getName()
     */
    @Override
    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#addAuthorizations(TaasAuthorization)
     */
    @Override
    public void addAuthorizations(TaasAuthorization authorizations) {
        fireOnPreWrite("authorizations", null, authorizations);
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<TaasAuthorization>();
        }
        this.authorizations.add(authorizations);
        fireOnPostWrite("authorizations", this.authorizations.size(), null, authorizations);
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#addAllAuthorizations(Collection<TaasAuthorization>)
     */
    @Override
    public void addAllAuthorizations(Collection<TaasAuthorization> values) {
        if (values == null) {
            return;
        }
        for (TaasAuthorization item : values) {
            addAuthorizations(item);
        }
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#getAuthorizationsByTopiaId(String)
     */
    @Override
    public TaasAuthorization getAuthorizationsByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(authorizations, topiaId);
    }
 
    /* (non-Javadoc)
     * @see TaasPrincipal#setAuthorizations(Collection<TaasAuthorization>)
     */
    @Override
    public void setAuthorizations(Collection<TaasAuthorization> values) {
        Collection<TaasAuthorization> _oldValue = authorizations;
        fireOnPreWrite("authorizations", _oldValue, values);
        authorizations = values;
        fireOnPostWrite("authorizations", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#removeAuthorizations(TaasAuthorization)
     */
    @Override
    public void removeAuthorizations(TaasAuthorization value) {
        fireOnPreWrite("authorizations", value, null);
        if ((this.authorizations == null) || (!this.authorizations.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("authorizations", this.authorizations.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#clearAuthorizations()
     */
    @Override
    public void clearAuthorizations() {
        if (this.authorizations == null) {
            return;
        }
        Collection<TaasAuthorization> _oldValue = new ArrayList<TaasAuthorization>(this.authorizations);
        fireOnPreWrite("authorizations", _oldValue, this.authorizations);
        this.authorizations.clear();
        fireOnPostWrite("authorizations", _oldValue, this.authorizations);
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#getAuthorizations()
     */
    @Override
    public Collection<TaasAuthorization> getAuthorizations() {
        return authorizations;
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#sizeAuthorizations()
     */
    @Override
    public int sizeAuthorizations() {
        if (authorizations == null) {
            return 0;
        }
        return authorizations.size();
    }

    /* (non-Javadoc)
     * @see TaasPrincipal#isAuthorizationsEmpty()
     */
    @Override
    public boolean isAuthorizationsEmpty() {
        int size = sizeAuthorizations();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("authorizations", this.authorizations).
         toString();
        return result;
    }
        
} //TaasPrincipalAbstract
