/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration.mappings;

import jakarta.persistence.criteria.CriteriaQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.nuiton.topia.migration.mappings.TMSVersion;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaUtil;
import org.nuiton.version.Version;
import org.nuiton.version.VersionBuilder;

public class TMSVersionHibernateDao {
    private static final Log log = LogFactory.getLog(TMSVersionHibernateDao.class);
    public static final String LEGACY_TABLE_NAME = "tmsVersion";
    public static final String TABLE_NAME = "tms_version";

    public static TMSVersion readVersion(Session session) throws TopiaException {
        try {
            HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(TMSVersion.class);
            criteria.from(TMSVersion.class);
            List list = session.createQuery(criteria).getResultList();
            TMSVersion result = list.isEmpty() ? null : (TMSVersion)list.get(0);
            return result;
        }
        catch (HibernateException he) {
            throw new TopiaException("Could not obtain version", (Throwable)he);
        }
    }

    public static void createTMSSchema(Metadata metadata) {
        SchemaExport schemaExport = new SchemaExport();
        EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
        if (log.isDebugEnabled()) {
            targetTypes.add(TargetType.STDOUT);
        }
        schemaExport.create(targetTypes, metadata);
    }

    public static void dropTMSSchema(Metadata metadata) {
        SchemaExport schemaExport = new SchemaExport();
        EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
        if (log.isDebugEnabled()) {
            targetTypes.add(TargetType.STDOUT);
        }
        schemaExport.drop(targetTypes, metadata);
    }

    public static TMSVersion saveVersion(Session session, String version) throws TopiaException {
        try {
            TMSVersion result = TMSVersion.valueOf(version);
            session.persist((Object)result);
            return result;
        }
        catch (HibernateException he) {
            throw new TopiaException("Could not create version " + version, (Throwable)he);
        }
    }

    public static void update(Session session, TMSVersion version) throws TopiaException {
        try {
            session.saveOrUpdate((Object)version);
        }
        catch (HibernateException he) {
            throw new TopiaException("Could not update version " + version, (Throwable)he);
        }
    }

    public static void deleteAll(Session session) throws TopiaException {
        try {
            HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(TMSVersion.class);
            criteria.from(TMSVersion.class);
            List list = session.createQuery(criteria).getResultList();
            for (TMSVersion o : list) {
                session.remove((Object)o);
            }
        }
        catch (HibernateException he) {
            throw new TopiaException("Could not delete all versions", (Throwable)he);
        }
    }

    public static Version getVersion(Configuration hibernateConfiguration, Session session, String tableName) {
        try {
            String schemaName = TopiaUtil.getSchemaName((Configuration)hibernateConfiguration);
            GetVersionWork work = new GetVersionWork(schemaName, tableName);
            session.doWork((Work)work);
            Version v = work.getVersion();
            return v;
        }
        catch (HibernateException he) {
            throw new TopiaException("Can't obtain dbVersion for reason " + he.getMessage(), (Throwable)he);
        }
    }

    public static class GetVersionWork
    implements Work {
        protected Version version;
        private final String tableName;
        private final String schemaName;

        public GetVersionWork(String schemaName, String tableName) {
            this.tableName = tableName;
            this.schemaName = schemaName;
        }

        public void execute(Connection connection) throws SQLException {
            String fullTableName = this.schemaName == null ? this.tableName : this.schemaName + "." + this.tableName;
            try (PreparedStatement st = connection.prepareStatement("select version from " + fullTableName + ";");){
                ResultSet set = st.executeQuery();
                if (set.next()) {
                    this.version = VersionBuilder.create((String)set.getString(1)).build();
                }
            }
            catch (SQLException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Could not find version", (Throwable)eee);
                }
                this.version = null;
            }
        }

        public Version getVersion() {
            return this.version;
        }
    }
}

