/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.topia.migration.MigrationServiceException;
import org.nuiton.topia.migration.mappings.TMSVersion;
import org.nuiton.util.Version;

public class DatabaseManager {
    private SessionFactory sessionFactory;
    private Configuration dbConfiguration = new Configuration();
    private static Log logger = LogFactory.getLog(DatabaseManager.class);
    private static String VERSIONNED_TABLES_SUFFIX = "_tmsv";

    public DatabaseManager(Properties pInfosConnexion) {
        this.dbConfiguration.setProperties(pInfosConnexion);
        logger.debug((Object)("Configuration url : " + pInfosConnexion.getProperty("hibernate.connection.url")));
        logger.debug((Object)("Configuration driver : " + pInfosConnexion.getProperty("hibernate.connection.driver_class")));
        logger.debug((Object)("Configuration dialect : " + pInfosConnexion.getProperty("hibernate.dialect")));
        logger.debug((Object)("Adding mappings for " + TMSVersion.class.getSimpleName()));
        this.dbConfiguration.addClass(TMSVersion.class);
        this.sessionFactory = this.dbConfiguration.buildSessionFactory();
    }

    public Configuration getDbConfiguration() {
        return this.dbConfiguration;
    }

    public Connection getConnection() {
        Connection result = this.sessionFactory.openStatelessSession().connection();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getDataBaseVersion() throws MigrationServiceException {
        Version version = null;
        logger.debug((Object)"Begin transaction to get version in database");
        Session session = this.sessionFactory.openSession();
        try {
            Transaction tx = session.beginTransaction();
            TMSVersion result = (TMSVersion)session.createCriteria(TMSVersion.class).uniqueResult();
            if (result != null) {
                version = new Version(result.getVersion().toString());
                logger.debug((Object)("Query executed, version found : " + version.getVersion()));
            } else {
                logger.debug((Object)"Query executed, no version found");
            }
            tx.commit();
        }
        catch (JDBCConnectionException e) {
            throw new MigrationServiceException("Connection to database refused, check your configuration !");
        }
        catch (SQLGrammarException e) {
            logger.debug((Object)"Exception on request : table not found");
            version = null;
        }
        finally {
            session.close();
        }
        return version;
    }

    public void renameTables(Configuration oldConfiguration, Version vdbVersion) {
        logger.debug((Object)("Renaming tables in configuration and database for version " + vdbVersion.getVersion()));
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        Iterator i = oldConfiguration.getTableMappings();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            String tableName = table.getName();
            String suffix = this.getTableSuffixForVersion(vdbVersion);
            String newTableName = tableName;
            if (tableName.endsWith(suffix)) {
                newTableName = tableName.substring(0, tableName.length() - suffix.length());
            }
            logger.debug((Object)("Renaming table " + tableName + " to " + newTableName));
            String sQuery = "ALTER TABLE " + tableName + " RENAME TO " + newTableName;
            SQLQuery sqlq = session.createSQLQuery(sQuery);
            sqlq.executeUpdate();
            table.setName(newTableName);
        }
        tx.commit();
        session.close();
    }

    public Configuration setRenamedTableSchema(Configuration oldConfiguration, Version vdbVersion) {
        logger.debug((Object)("Renaming tables in configuration for version " + vdbVersion.getVersion()));
        oldConfiguration.buildMappings();
        Iterator i = oldConfiguration.getTableMappings();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            if (!table.isPhysicalTable()) continue;
            Iterator fKeys = table.getForeignKeyIterator();
            while (fKeys.hasNext()) {
                ForeignKey fKey = (ForeignKey)fKeys.next();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Changing constraints name : " + fKey.getName() + " to " + fKey.getName() + vdbVersion.getValidName()));
                }
                fKey.setName(fKey.getName() + vdbVersion.getValidName());
            }
            String tableName = table.getName();
            String newTableName = tableName + this.getTableSuffixForVersion(vdbVersion);
            logger.debug((Object)("Renaming table " + tableName + " to " + newTableName));
            table.setName(newTableName);
        }
        return oldConfiguration;
    }

    public void setApplicationSchemaInDatabase(Configuration newConfiguration) {
        logger.debug((Object)"Creating new schema");
        this.createSchema(newConfiguration);
        logger.debug((Object)"Schema created");
    }

    protected void createSchema(Configuration configuration) {
        SchemaExport schemaExport = new SchemaExport(configuration);
        schemaExport.execute(false, true, false, true);
    }

    protected void dropSchema(Configuration configuration) {
        SchemaExport schemaExport = new SchemaExport(configuration);
        schemaExport.drop(false, true);
    }

    public void createVersionTable() {
        logger.debug((Object)"Adding table to put version");
        SchemaExport schemaExport = new SchemaExport(this.dbConfiguration);
        schemaExport.create(false, true);
        logger.debug((Object)("Table for " + TMSVersion.class.getSimpleName() + " created"));
    }

    public void putVersionInDatabase(Version newVersion) {
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        logger.debug((Object)"Deleting existing versions");
        List lVersion = session.createCriteria(TMSVersion.class).list();
        for (Object o : lVersion) {
            TMSVersion v = (TMSVersion)o;
            logger.debug((Object)("Deleting version " + v.getVersion()));
            session.delete((Object)v);
        }
        logger.debug((Object)("Setting database version to " + newVersion.getVersion()));
        TMSVersion version = new TMSVersion(newVersion.getVersion());
        session.save((Object)version);
        tx.commit();
        session.close();
    }

    public void removeTablesFromOldMapping(Configuration oldConfiguration) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Removing schema");
        }
        this.dropSchema(oldConfiguration);
    }

    protected String getTableSuffixForVersion(Version version) {
        String suffix = VERSIONNED_TABLES_SUFFIX + version.getValidName();
        return suffix;
    }

    public boolean isSchemaExist(Configuration configuration) {
        boolean exist = false;
        Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
        ConnectionProvider connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)configuration.getProperties());
        try {
            Iterator tables = configuration.getTableMappings();
            if (tables.hasNext()) {
                Table testTable = (Table)tables.next();
                Connection connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect);
                TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                if (tmd != null) {
                    exist = true;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Cant connect to database", (Throwable)e);
        }
        return exist;
    }

    public void disconnect() {
        this.sessionFactory.close();
    }
}

