/* *##% ToPIA - Migration service
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/
package org.nuiton.topia.migration.common;

import java.io.Serializable;
import org.nuiton.util.Version;
import java.util.Map;

/**
 * MapAdapterAdmin.java
 *
 * Interface interne, contenant plus de méthodes que celle du developpeur.
 * 
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1459 $
 *
 * Last update : $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 */
public interface MapAdapterAdmin extends MapAdapter {

    /**
     * Modificateur qui permet d'initialiser l'entrée de l'objet.
     *
     * @param nameClass Nom de la classe entrante
     * @param _idInner la valeur de l'id
     * @param _inner la map en entree
     * @param nameAttId le nom de l'attribut etant l'identifiant
     */
    void setInner(ProxyClass nameClass, String nameAttId, Serializable _idInner, Map<String, Object> _inner);

    /**
     * Modificateur qui permet d'initialiser l'entrée de l'objet en supposant
     * que l'objet entrant est de la même classe que celui sortant.
     *
     * @param _idInner Identifiant de l'objet entrant
     * @param _inner la map d'entree
     * @param nameAttId le nom de l'attribut etant l'identifiant
     */
    void setInner(String nameAttId, Serializable _idInner, Map<String, Object> _inner);

    /**
     * Retourne le nom de la classe persistante d'entrée.
     * @return le nom de la classe.
     */
    ProxyClass getInnerClass();

    /**
     * Retourne le nom de la classe persistante de sortie.
     * @return le nom de la classe.
     */
    ProxyClass getOuterClass();

    /**
     * Retourne la version en entrée.
     * @return la version en entrée.
     */
    Version getInnerVersion();

    /**
     * Modificateur de la version entrante.
     * @param innerVersion la version entrante.
     */
    void setInnerVersion(Version innerVersion);

    /**
     * Retourne la version en sortie.
     * @return la version en sortie.
     */
    Version getOuterVersion();

    /**
     * Modificateur de la version sortante.
     * @param outerVersion la version sortante.
     */
    void setOuterVersion(Version outerVersion);

    /**
     * Méthode pour basculer la version sortante sur la version entrante.
     */
    void switchVersion();

    /**
     * Modificateur de la classe sortante.
     * @param outerClass La classe de sortie.
     */
    void setOuterClass(ProxyClass outerClass);

    /**
     * Modificateur d'un parametre de la mode en entrée.
     *
     * @param nameAttribut
     * @param value
     */
    void setOldValue(String nameAttribut, Serializable value);
}
