/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.framework.TopiaUtil;

public class TopiaContextFactory {
    private static final Log log = LogFactory.getLog(TopiaContextFactory.class);
    private static final String DEFAULT_CONFIG_PROPERTIES = "TopiaContextImpl.properties";
    protected static Map<Properties, TopiaContext> contextCache = new ReferenceMap(0, 1);
    public static final String CONFIG_DEFAULT_SCHEMA = "hibernate.default_schema";
    public static final String CONFIG_USER = "hibernate.connection.username";
    public static final String CONFIG_PASS = "hibernate.connection.password";
    public static final String CONFIG_DRIVER = "hibernate.connection.driver_class";
    public static final String CONFIG_DIALECT = "hibernate.dialect";
    public static final String CONFIG_CONNECTION_PROVIDER = "hibernate.connection.provider_class";
    public static final String CONFIG_BYTECODE_PROVIDER = "hibernate.bytecode.provider";
    public static final String CONFIG_CURRENT_SESSION_CONTEXT_CLASS = "hibernate.current_session_context_class";
    public static final String CONFIG_GENERATE_STATISTICS = "hibernate.generate_statistics";
    public static final String CONFIG_FORMAT_SQL = "hibernate.format_sql";
    public static final String CONFIG_HBM2DDL_AUTO = "hibernate.hbm2ddl.auto";
    public static final String CONFIG_POOL_SIZE = "hibernate.connection.pool_size";
    public static final String CONFIG_SHOW_SQL = "hibernate.show_sql";
    public static final String CONFIG_URL = "hibernate.connection.url";
    public static final String CONFIG_PERSISTENCE_DIRECTORIES = "topia.persistence.directories";
    public static final String CONFIG_PERSISTENCE_CLASSES = "topia.persistence.classes";
    public static final String CONFIG_PERSISTENCE_PROPERTIES_FILE = "topia.persistence.properties.file";
    public static final String CONFIG_PERSISTENCE_TOPIA_ID_FACTORY_CLASS_NAME = "topia.persistence.topiaIdFactoryClassName";

    public static List<String> getContextOpened() {
        ArrayList<String> result = new ArrayList<String>();
        for (Properties e : contextCache.keySet()) {
            result.add(e.getProperty(CONFIG_URL));
        }
        return result;
    }

    public static void removeContext(TopiaContext context) {
        Iterator<TopiaContext> it = contextCache.values().iterator();
        while (it.hasNext()) {
            TopiaContext curr = it.next();
            if (curr != context) continue;
            it.remove();
            break;
        }
    }

    public static TopiaContext getContext() throws TopiaNotFoundException {
        Properties config = TopiaUtil.getProperties(DEFAULT_CONFIG_PROPERTIES);
        TopiaContext result = TopiaContextFactory.getContext(config);
        return result;
    }

    public static TopiaContext getContext(Properties config) throws TopiaNotFoundException {
        Properties cloned = new Properties();
        for (String key : config.stringPropertyNames()) {
            cloned.setProperty(key, config.getProperty(key));
        }
        TopiaContext result = contextCache.get(cloned);
        if (result == null) {
            result = new TopiaContextImpl(cloned);
            if (log.isDebugEnabled()) {
                log.debug((Object)("instantiate new topiaContext : " + result));
            }
            contextCache.put(cloned, result);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("topiaContext found : " + result));
        }
        return result;
    }
}

