/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class EntityHibernateMappingGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(EntityHibernateMappingGenerator.class);
    private Map<String, String[]> columnNamesMap = new HashMap<String, String[]>();

    public String getFilenameForClass(ObjectModelClass clazz) {
        String DOName = TopiaGeneratorUtil.getDOType((ObjectModelElement)clazz, (ObjectModel)this.model);
        return DOName.replace('.', File.separatorChar) + ".hbm.xml";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        String proxyTagValue;
        String persistenceType = TopiaGeneratorUtil.getPersistenceType((ObjectModelElement)clazz);
        if (!clazz.hasStereotype("entity") && "hibernate".equals(persistenceType)) {
            return;
        }
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.write("<!DOCTYPE hibernate-mapping PUBLIC \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\" \"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\">\n");
        output.write("<hibernate-mapping default-access=\"field\" auto-import=\"true\" package=\"" + clazz.getPackageName() + "\">\n");
        output.write("");
        boolean haveSuper = clazz.getSuperclasses().size() > 0;
        ArrayList<ObjectModelAttribute> naturalAttributes = new ArrayList<ObjectModelAttribute>();
        ArrayList<ObjectModelAttribute> noneNaturalAttributes = new ArrayList<ObjectModelAttribute>();
        String clazzDOType = TopiaGeneratorUtil.getDOType((ObjectModelElement)clazz, (ObjectModel)this.model);
        String tableName = TopiaGeneratorUtil.getDBName((ObjectModelElement)clazz);
        String isAbstract = BooleanUtils.toStringTrueFalse((boolean)clazz.isAbstract());
        String clazzFQN = clazz.getQualifiedName();
        String optionalAttributes = "";
        String schema = TopiaGeneratorUtil.getSchemaName((ObjectModelElement)clazz, (ObjectModel)this.model);
        if (schema != null) {
            optionalAttributes = optionalAttributes + "schema=\"" + schema + "\" ";
        }
        if ((proxyTagValue = TopiaGeneratorUtil.findTagValue((String)"hibernateProxyInterface", (ObjectModelElement)clazz, (Model)this.model)) == null || !proxyTagValue.equals("none")) {
            optionalAttributes = optionalAttributes + "proxy=\"" + clazzFQN + "\" ";
        }
        if (haveSuper) {
            ObjectModelClass superClass = (ObjectModelClass)clazz.getSuperclasses().iterator().next();
            String superClassname = superClass.getQualifiedName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("superClass for " + clazz.getQualifiedName() + " is " + superClassname));
            }
            String superClassDOType = TopiaGeneratorUtil.getDOType(superClassname, (ObjectModel)this.model);
            output.write("    <union-subclass name=\"" + clazzDOType + "\" extends=\"" + superClassDOType + "\" table=\"" + tableName + "\" node=\"" + clazzDOType + "\" abstract=\"" + isAbstract + "\" " + optionalAttributes + ">\n");
            output.write("        <!--key column=\"topiaId\"/-->\n");
            output.write("");
            noneNaturalAttributes.addAll(clazz.getAttributes());
        } else {
            output.write("    <class name=\"" + clazzDOType + "\" table=\"" + tableName + "\" node=\"" + clazzDOType + "\" abstract=\"" + isAbstract + "\" " + optionalAttributes + ">\n");
            output.write("        <id name=\"topiaId\" type=\"string\" length=\"255\" node=\"@topiaId\"/>\n");
            output.write("");
            for (ObjectModelAttribute attr : clazz.getAttributes()) {
                if (TopiaGeneratorUtil.isNaturalId(attr)) {
                    naturalAttributes.add(attr);
                    continue;
                }
                noneNaturalAttributes.add(attr);
            }
            if (!naturalAttributes.isEmpty()) {
                String mutableStr;
                boolean mutable = TopiaGeneratorUtil.isNaturalIdMutable(clazz);
                String string = mutableStr = mutable ? " mutable=\"true\"" : "";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("natural-id detected for class " + clazz.getName() + " (" + mutableStr + ") attributes : " + naturalAttributes));
                }
                output.write("        <natural-id" + mutableStr + ">\n");
                output.write("");
                this.generateAttributes(output, clazz, naturalAttributes, "    ");
                output.write("        </natural-id>\n");
                output.write("");
            }
            output.write("        <version name=\"topiaVersion\" type=\"long\" node=\"@topiaVersion\"/>\n");
            output.write("        <property name=\"topiaCreateDate\" type=\"timestamp\" node=\"@topiaCreateDate\"/>\n");
            output.write("");
        }
        this.generateAttributes(output, clazz, noneNaturalAttributes, "");
        if (haveSuper) {
            output.write("    </union-subclass>\n");
            output.write("");
        } else {
            output.write("    </class>\n");
            output.write("");
        }
        output.write("</hibernate-mapping>\n");
        output.write("");
    }

    protected void generateAttributes(Writer output, ObjectModelClass clazz, List<ObjectModelAttribute> attributes, String prefix) throws IOException {
        for (ObjectModelAttribute attr : attributes) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                if (attr.getClassifier() != null && attr.getClassifier().hasStereotype("entity")) {
                    if (GeneratorUtil.isNMultiplicity((int)attr.getReverseMaxMultiplicity()) && !attr.hasAssociationClass()) {
                        this.generateHibernateManyToOne(output, attr, prefix);
                        continue;
                    }
                    this.generateHibernateOneToOne(output, attr, prefix);
                    continue;
                }
                this.generateHibernateProperty(output, attr, prefix);
                continue;
            }
            if (attr.getClassifier() != null && attr.getClassifier().hasStereotype("entity")) {
                if (GeneratorUtil.isNMultiplicity((int)attr.getReverseMaxMultiplicity()) && !attr.hasAssociationClass()) {
                    this.generateHibernateManyToMany(output, attr, prefix);
                    continue;
                }
                this.generateHibernateOneToMany(output, attr, prefix);
                continue;
            }
            this.generateHibernateMany(output, attr, prefix);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String notNull = " " + this.generateFromTagValue(attr, "notNull", "not-null");
                String attrName = this.getName(attr, true);
                String attrType = this.getType(attr, true);
                String attrColumn = TopiaGeneratorUtil.getDBName((ObjectModelElement)attr);
                output.write("" + prefix + "        <many-to-one name=\"" + attrName + "\" class=\"" + attrType + "\" column=\"" + attrColumn + "\" node=\"" + attrName + "/@topiaId\" embed-xml=\"false\" " + notNull + "/>\n");
                output.write("");
            }
        }
    }

    protected String getName(ObjectModelAttribute attr) {
        return this.getName(attr, false);
    }

    protected String getName(ObjectModelAttribute attr, boolean isAssoc) {
        String result = GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName());
        if (attr.hasAssociationClass() && !isAssoc) {
            result = TopiaGeneratorUtil.getAssocAttrName(attr);
        }
        return result;
    }

    protected String getType(ObjectModelAttribute attr) {
        return this.getType(attr, false);
    }

    protected String getType(ObjectModelAttribute attr, boolean isAssoc) {
        String type = attr.getType();
        if (TopiaGeneratorUtil.notEmpty((String)((ObjectModel)this.model).getTagValue(type))) {
            String typeString = ((ObjectModel)this.model).getTagValue(type);
            int bracketIndex = typeString.indexOf(40);
            if (bracketIndex != -1) {
                type = typeString.substring(0, bracketIndex);
                int bracketEndIndex = typeString.indexOf(41, bracketIndex + 1);
                String colmunList = bracketEndIndex != -1 ? typeString.substring(bracketIndex + 1, bracketEndIndex) : typeString.substring(bracketIndex);
                this.columnNamesMap.put(type, colmunList.split(","));
            } else {
                type = typeString;
            }
        }
        if (attr.hasAssociationClass() && !isAssoc) {
            type = attr.getAssociationClass().getQualifiedName();
        }
        return TopiaGeneratorUtil.getDOType(type, (ObjectModel)this.model);
    }

    protected void generateHibernateProperty(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        String attrType = this.getType(attr);
        String accessField = "field";
        if (attr.hasTagValue("access")) {
            accessField = attr.getTagValue("access");
        }
        String attrName = attr.getName();
        String declaringElementDBName = TopiaGeneratorUtil.getDBName(attr.getDeclaringElement());
        String tableName = declaringElementDBName + "_" + attrName;
        if (attrType.trim().endsWith("[]")) {
            attrType = attrType.trim().substring(0, attrType.trim().length() - 2);
            String optionalAttributes = "";
            String schema = TopiaGeneratorUtil.getSchemaName((ObjectModelElement)attr, (ObjectModel)this.model);
            if (schema != null) {
                optionalAttributes = optionalAttributes + "schema=\"" + schema + "\" ";
            }
            if (attr.isIndexed()) {
                String indexName = tableName + "_idx";
                optionalAttributes = optionalAttributes + "index=\"" + indexName + "\" ";
            }
            output.write("" + prefix + "        <primitive-array name=\"" + attrName + "\" table=\"" + tableName + "\" access=\"" + accessField + "\" " + optionalAttributes + ">\n");
            output.write("" + prefix + "          <key column=\"" + declaringElementDBName + "\"/>\n");
            output.write("" + prefix + "          <list-index column=\"" + attrName + "_idx\"/>\n");
            output.write("" + prefix + "          <element type=\"" + attrType + "\"/>\n");
            output.write("" + prefix + "        </primitive-array>\n");
            output.write("");
        } else {
            String optionalAttributes = "";
            if (attr.isIndexed()) {
                String indexName = tableName + "_idx";
                optionalAttributes = optionalAttributes + "index=\"" + indexName + "\"";
            }
            if (attr.hasStereotype("unique")) {
                optionalAttributes = optionalAttributes + " unique=\"true\"";
            }
            optionalAttributes = optionalAttributes + this.generateFromTagValue(attr, "notNull", "not-null");
            output.write("" + prefix + "        <property name=\"" + attrName + "\" type=\"" + attrType + "\" access=\"" + accessField + "\" ");
            optionalAttributes = optionalAttributes.trim();
            String[] columnNames = this.columnNamesMap.get(attrType);
            if (columnNames == null || columnNames.length == 0) {
                optionalAttributes = optionalAttributes + this.generateFromTagValue(attr, "length", "length");
                String attrColumn = TopiaGeneratorUtil.getDBName((ObjectModelElement)attr);
                if (!(optionalAttributes = optionalAttributes.trim()).isEmpty()) {
                    optionalAttributes = " " + optionalAttributes;
                }
                if (StringUtils.isNotEmpty((String)attr.getDefaultValue())) {
                    String defaultValue = attr.getDefaultValue().trim();
                    output.write("" + optionalAttributes + ">\n");
                    output.write("" + prefix + "            <column name=\"" + attrColumn + "\" default=\"" + defaultValue + "\"/>\n");
                    output.write("" + prefix + "        </property>\n");
                    output.write("");
                } else {
                    output.write("column=\"" + attrColumn + "\" node=\"" + attrName + "\"" + optionalAttributes + "/>\n");
                    output.write("");
                }
            } else {
                output.write("" + optionalAttributes + ">\n");
                output.write("");
                for (String columnName : columnNames) {
                    columnName = attrName + "_" + columnName.trim();
                    output.write("" + prefix + "            <column name=\"" + columnName + "\"/>\n");
                    output.write("");
                }
                output.write("" + prefix + "        </property>\n");
                output.write("");
            }
        }
    }

    protected void generateHibernateOneToOne(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean unique = TopiaGeneratorUtil.isOneMultiplicity((ObjectModelAttribute)attr);
        this.generateHibernateManyToOne(output, attr, unique, prefix);
    }

    protected void generateHibernateOneToMany(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean needsIndex = attr.isIndexed();
        boolean isInverse = attr.getReverseAttribute().isNavigable();
        isInverse |= TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model);
        String attrName = this.getName(attr);
        String attrType = this.getType(attr);
        String reverseAttrDBName = TopiaGeneratorUtil.getReverseDBName(attr);
        String orderBy = this.generateFromTagValue(attr, "orderBy", "order-by");
        String cascade = "";
        if (attr.isComposite() || attr.hasAssociationClass()) {
            cascade = cascade + "cascade=\"all,delete-orphan\" ";
        }
        String lazy = this.generateFromTagValue(attr, "lazy", "lazy", "true");
        String fetch = this.generateFromTagValue(attr, "fetch", "fetch");
        String collType = TopiaGeneratorUtil.getNMultiplicityHibernateType(attr);
        String inverse = "";
        if (isInverse) {
            inverse = "inverse=\"true\" ";
        }
        if (needsIndex) {
            output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" " + inverse + "" + lazy + "" + cascade + "node=\"" + attrName + "\" embed-xml=\"false\">\n");
            output.write("" + prefix + "            <key column=\"" + reverseAttrDBName + "\"/>\n");
            output.write("" + prefix + "            <list-index column=\"" + reverseAttrDBName + "_idx\"/>\n");
            output.write("" + prefix + "            <one-to-many class=\"" + attrType + "\" node=\"topiaId\" embed-xml=\"false\"/>\n");
            output.write("" + prefix + "        </" + collType + ">\n");
            output.write("");
        } else {
            output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" " + inverse + "" + orderBy + "" + fetch + "" + lazy + "" + cascade + "node=\"" + attrName + "\" embed-xml=\"false\">\n");
            output.write("" + prefix + "            <key column=\"" + reverseAttrDBName + "\"/>\n");
            output.write("" + prefix + "            <one-to-many class=\"" + attrType + "\" node=\"topiaId\" embed-xml=\"false\"/>\n");
            output.write("" + prefix + "        </" + collType + ">\n");
            output.write("");
        }
    }

    private String generateFromTagValue(ObjectModelAttribute attr, String tagName, String attributeName) {
        return this.generateFromTagValue(attr, tagName, attributeName, null);
    }

    private String generateFromTagValue(ObjectModelAttribute attr, String tagName, String attributeName, String defaultValue) {
        String result = "";
        if (attr.hasTagValue(tagName) || defaultValue != null) {
            result = result + attributeName + "=\"";
            result = attr.hasTagValue(tagName) ? result + attr.getTagValue(tagName) : result + defaultValue;
            result = result + "\" ";
        }
        return result;
    }

    protected void generateHibernateMany(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean needsIndex = attr.isIndexed();
        String attrName = this.getName(attr);
        String attrType = this.getType(attr);
        String collType = TopiaGeneratorUtil.getNMultiplicityHibernateType(attr);
        String lazy = this.generateFromTagValue(attr, "lazy", "lazy");
        String attrColumn = TopiaGeneratorUtil.getDBName((ObjectModelElement)attr);
        output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" " + lazy + "node=\"" + attrName + "\" embed-xml=\"true\">\n");
        output.write("" + prefix + "            <key column=\"OWNER\"/>\n");
        output.write("");
        if (needsIndex) {
            output.write("" + prefix + "        <list-index/>\n");
            output.write("");
        }
        output.write("" + prefix + "            <element type=\"" + attrType + "\" column=\"" + attrColumn + "\" node=\"id\"/>\n");
        output.write("" + prefix + "        </" + collType + ">\n");
        output.write("");
    }

    protected void generateHibernateManyToOne(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        this.generateHibernateManyToOne(output, attr, false, prefix);
    }

    protected void generateHibernateManyToOne(Writer output, ObjectModelAttribute attr, boolean isUnique, String prefix) throws IOException {
        String attrName = this.getName(attr);
        String attrType = this.getType(attr);
        String attrColumn = TopiaGeneratorUtil.getDBName((ObjectModelElement)attr);
        output.write("" + prefix + "        <many-to-one name=\"" + attrName + "\" class=\"" + attrType + "\" column=\"" + attrColumn + "\" ");
        if (attr.isComposite() || attr.hasAssociationClass()) {
            output.write("cascade=\"delete\" ");
        }
        if (attr.getReverseAttribute() != null && TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr.getReverseAttribute(), (ObjectModel)this.model)) {
            output.write("access=\"field\" ");
        }
        String lazy = this.generateFromTagValue(attr, "lazy", "lazy");
        output.write("" + lazy + "");
        String notNull = " " + this.generateFromTagValue(attr, "notNull", "not-null");
        output.write("" + notNull + "");
        if (isUnique) {
            output.write("unique=\"true\" ");
        }
        output.write("node=\"" + attrName + "/@topiaId\" embed-xml=\"false\"");
        output.write("/>\n");
        output.write("");
    }

    protected void generateHibernateManyToMany(Writer output, ObjectModelAttribute attr, String prefix) throws IOException {
        boolean isInverse = attr.isNavigable() && attr.getReverseAttribute().isNavigable();
        isInverse &= GeneratorUtil.isFirstAttribute((ObjectModelAttribute)attr);
        boolean needsIndex = attr.isIndexed();
        String cascade = "";
        if (attr.isComposite() || attr.hasAssociationClass()) {
            cascade = " cascade=\"delete,delete-orphan\"";
        }
        String attrType = this.getType(attr);
        String attrName = this.getName(attr);
        String attrColumn = TopiaGeneratorUtil.getDBName((ObjectModelElement)attr);
        String lazy = this.generateFromTagValue(attr, "lazy", "lazy", "true");
        String orderBy = this.generateFromTagValue(attr, "orderBy", "order-by");
        String collType = TopiaGeneratorUtil.getNMultiplicityHibernateType(attr);
        String tableName = TopiaGeneratorUtil.getManyToManyTableName(attr);
        String inverse = "";
        if (isInverse) {
            inverse = "inverse=\"true\" ";
        }
        String reverseAttrDBName = TopiaGeneratorUtil.getReverseDBName(attr);
        output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\" table=\"" + tableName + "\" " + inverse + "" + lazy + "" + cascade + " node=\"" + attrName + "\" embed-xml=\"true\">\n");
        output.write("" + prefix + "            <key column=\"" + reverseAttrDBName + "\"/>\n");
        output.write("");
        if (needsIndex) {
            output.write("" + prefix + "        <list-index column=\"" + reverseAttrDBName + "_idx\"/>\n");
            output.write("");
        }
        output.write("" + prefix + "            <many-to-many class=\"" + attrType + "\" column=\"" + attrColumn + "\" " + orderBy + "node=\"topiaId\"/>\n");
        output.write("" + prefix + "        </" + collType + ">\n");
        output.write("");
    }
}

