package org.nuiton.topiatest.deletetest;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class Party2DAOAbstract<E extends Party2> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Party2.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<org.nuiton.topiatest.deletetest.Contact2> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from contact2 main, contacts_party2 secondary " +
                    "where main.topiaid=secondary.contacts" +
                    " and secondary.party2='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaTestDAOHelper.getImplementationClass(org.nuiton.topiatest.deletetest.Contact2.class)).list();
            for (org.nuiton.topiatest.deletetest.Contact2 item : list) {
                item.removeParty2(entity);
            }
        }

        super.delete(entity);
    }

    /**
     * findContainsContacts :
     * Retourne le premier élément trouvé dont l'attribut contacts contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsContacts(Contact2... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Party2.CONTACTS, Arrays.asList(v));
        E result = findContainsProperties("contacts", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsContacts :
     * Retourne les éléments trouvé dont l'attribut contacts contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsContacts(Contact2... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Party2.CONTACTS, Arrays.asList(v));
        List<E> results = findAllContainsProperties("contacts", Arrays.asList(v));
        return results;
    }


} //Party2DAOAbstract<E extends Party2>
