package org.nuiton.topiatest;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class DepartmentDAOAbstract<E extends Department> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Department.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByLeader :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut leader le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLeader(Employe v) throws TopiaException {
        E result = findByProperty("leader", v);
        return result;
    }

    /**
     * findAllByLeader :
     * Retourne les éléments ayant comme valeur pour l'attribut leader le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLeader(Employe v) throws TopiaException {
        List<E> result = findAllByProperty("leader", v);
        return result;
    }

    /**
     * findByCompany :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut company le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCompany(Company v) throws TopiaException {
        E result = findByProperty("company", v);
        return result;
    }

    /**
     * findAllByCompany :
     * Retourne les éléments ayant comme valeur pour l'attribut company le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCompany(Company v) throws TopiaException {
        List<E> result = findAllByProperty("company", v);
        return result;
    }

    /**
     * findContainsProduct :
     * Retourne le premier élément trouvé dont l'attribut product contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsProduct(Product... v) throws TopiaException {
        E result = findContainsProperties("product", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsProduct :
     * Retourne les éléments trouvé dont l'attribut product contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsProduct(Product... v) throws TopiaException {
        List<E> results = findAllContainsProperties("product", Arrays.asList(v));
        return results;
    }


} //DepartmentDAOAbstract<E extends Department>
