/*
 * *##% 
 * ToPIA - Persistence
 * Copyright (C) 2007 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.topia.generator;

import org.apache.commons.lang.StringUtils;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.*;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*{generator option: parentheses = false}*/

/*{generator option: writeString = +}*/
/**
 * BeanTransformer
 * <p/>
 * Created: 28 oct. 2009
 *
 * @author fdesbois
 * @version $Revision: 692 $
 *          <p/>
 *          Mise a jour: $Date: 2009-11-04 18:41:32 +0100 (mer. 04 nov. 2009) $
 *          par : $Author: fdesbois $
 */
public class ObjectModelTransformerToJavaBean extends ObjectModelTransformerToJava {

    private static final Log log = LogFactory.getLog(ObjectModelTransformerToJavaBean.class);

    @Override
    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_BEAN) &&
                !clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
            return;
        }

        ObjectModelClass resultClass = null;
        if (clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_BEAN)) {
            resultClass = createAbstractClass(clazz.getName(), clazz.getPackageName());
        } else {
            resultClass = createClass(clazz.getName(), clazz.getPackageName());
        }

        List<ObjectModelAttribute> attributes = (List<ObjectModelAttribute>) clazz.getAttributes();

        createForDTO(resultClass, clazz, attributes);

        // Set superclass
        Iterator<ObjectModelClass> j = clazz.getSuperclasses().iterator();
        if (j.hasNext()) {
            ObjectModelClass p = j.next();
            setSuperClass(resultClass, p.getQualifiedName());
        }

        // Add interfaces from inputModel
        for (Iterator<ObjectModelInterface> i = clazz.getInterfaces().iterator(); i.hasNext();) {
            ObjectModelClassifier parentInterface = i.next();
            addInterface(resultClass, parentInterface.getQualifiedName());
        }

        // Default constructor
        ObjectModelOperation constructor = addConstructor(resultClass, ObjectModelModifier.PUBLIC);

        createListeners(resultClass, clazz);

        boolean hasEntity = false;
        boolean hasMultipleAttribute = false;
        String toStringAppend = ""; // Append pour la méthode toString()
        String initTabs = ""; // initialisation des tableaux dans le constructeur

        // Add attributes with getter/setter
        for (ObjectModelAttribute attr : attributes) {

            if (attr.isNavigable() || attr.hasAssociationClass()) {
                String attrType = attr.getType();
                String simpleType = GeneratorUtil.getSimpleName(attrType);
                String attrName = attr.getName();
                String attrNameCapitalized = StringUtils.capitalize(attrName);

                // multiple attribute
                if (attr.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ARRAY)) {

                    int maxSize = attr.getMaxMultiplicity();
                    int maxSizeMoinsUn = maxSize - 1;

                    initTabs += "\n\tthis." + attrName + " = new " + attrType + "[" + maxSize + "];";

                    // Set Value
                    ObjectModelOperation setValue = addOperation(resultClass, "set" + attrNameCapitalized,
                           "void", ObjectModelModifier.PUBLIC);
                    addParameter(setValue, "int", "index");
                    addParameter(setValue, attrType, "value");
                    addException(setValue, "java.lang.ArrayIndexOutOfBoundsException");
                    setOperationBody(setValue, ""
    /*{
        if (index >= <%=maxSize%> || index < 0) {
            throw new ArrayIndexOutOfBoundsException("Wrong index [" + index + "] for array <%=attrName%>," +
                    "index must be between 0 and <%=maxSizeMoinsUn%>");
        }
        <%=simpleType%>[] oldValue = get<%=attrNameCapitalized%>();
        this.<%=attrName%>[index] = value;
        firePropertyChange("<%=attrName%>", oldValue, this.<%=attrName%>);
    }*/
                    );

                    // Get Value
                    ObjectModelOperation getValue = addOperation(resultClass, "get" + attrNameCapitalized,
                           attrType, ObjectModelModifier.PUBLIC);
                    addParameter(getValue, "int", "index");
                    addException(setValue, "java.lang.ArrayIndexOutOfBoundsException");
                    setOperationBody(getValue, ""
    /*{
        if (index >= <%=maxSize%> || index < 0) {
            throw new ArrayIndexOutOfBoundsException("Wrong index [" + index + "] for array <%=attrName%>," +
                    "index must be between 0 and <%=maxSizeMoinsUn%>");
        }
        return this.<%=attrName%>[index];
    }*/
                    );

                    attrType += "[]";
                    simpleType = GeneratorUtil.getSimpleName(attrType);
                } else if (GeneratorUtil.isNMultiplicity(attr)) {
                    hasMultipleAttribute = true;

                    // Add getChild
                    ObjectModelOperation getChild = addOperation(resultClass, "get" + attrNameCapitalized,
                            attrType, ObjectModelModifier.PUBLIC);
                    addParameter(getChild, "int", "index");
                    setOperationBody(getChild, ""
    /*{
        <%=simpleType%> o = getChild(<%=attrName%>, index);
        return o;
    }*/
                    );

                    // Add getEntity
                    ObjectModelClass attrEntity = null;
                    if (getModel().hasClass(attr.getType())) {
                        attrEntity = getModel().getClass(attr.getType());
                    }
                    boolean isEntity = (attrEntity != null && attrEntity.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY));

                    if (isEntity) {
                        hasEntity = true;
                        ObjectModelOperation getChildEntity = addOperation(resultClass, "get" + attrNameCapitalized,
                            attrType, ObjectModelModifier.PUBLIC);
                        addParameter(getChildEntity, String.class.getName(), "topiaId");
                        setOperationBody(getChildEntity, ""
    /*{
        <%=simpleType%> o = getEntity(<%=attrName%>, topiaId);
        return o;
    }*/
                        );
                    }

                    // Add addChild
                    ObjectModelOperation addChild = addOperation(resultClass, "add" + attrNameCapitalized,
                            attrType, ObjectModelModifier.PUBLIC);
                    addParameter(addChild, attrType, attrName);
                    setOperationBody(addChild, ""

    /*{
        get<%=attrNameCapitalized%>().add(<%=attrName%>);
        firePropertyChange("<%=attrName%>", null, <%=attrName%>);
        return <%=attrName%>;
    }*/
                    );

                    // Add removeChild
                    ObjectModelOperation removeChild = addOperation(resultClass, "remove" + attrNameCapitalized,
                            "boolean", ObjectModelModifier.PUBLIC);
                    addParameter(removeChild, attrType, attrName);
                    setOperationBody(removeChild, ""

    /*{
        boolean  removed = get<%=attrNameCapitalized%>().remove(<%=attrName%>);
        if (removed) {
            firePropertyChange("<%=attrName%>", <%=attrName%>, null);
        }
        return removed;
    }*/
                    );

                    // Change type for Multiple attribute
                    if (attr.isOrdered()) {
                        attrType = List.class.getName() + "<" + attrType + ">";
                    } else {
                        attrType = Collection.class.getName() + "<" + attrType + ">";
                    }
                    simpleType = GeneratorUtil.getSimpleName(attrType);
                } // end multiple attribute

                if (attr.hasAssociationClass()) {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    attrName = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                    attrType = attr.getAssociationClass().getName();
                }

                // Add attribute to the class
                String visibility = attr.getVisibility();
                addAttribute(resultClass, attrName, attrType, "", ObjectModelModifier.toValue(visibility));

                // Add getter operation
                ObjectModelOperation getter = addOperation(resultClass, "get" + attrNameCapitalized, attrType,
                        ObjectModelModifier.PUBLIC);
                setOperationBody(getter, ""
    /*{
        return this.<%=attrName%>;
    }*/
                );

                // Add setter operation
                ObjectModelOperation setter = addOperation(resultClass, "set" + attrNameCapitalized, "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(setter, attrType, "newValue");
                setOperationBody(setter, ""
    /*{
        <%=simpleType%> oldValue = get<%=attrNameCapitalized%>();
        this.<%=attrName%> = newValue;
        firePropertyChange("<%=attrName%>", oldValue, newValue);
    }*/
                );

                // toString append for toString method
                toStringAppend += "\n\t\t.append(\"" + attrName + "\", this." + attrName + ")";

            }
        }

        // Add helper operations
        if (hasMultipleAttribute) {
            ObjectModelOperation getChild = addOperation(resultClass, "getChild", "<T> T",
                    ObjectModelModifier.PROTECTED);
            addParameter(getChild, "java.util.Collection<T>", "childs");
            addParameter(getChild, "int", "index");
            setOperationBody(getChild, ""
    /*{
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }*/
            );
        }

        if (hasEntity) {
            ObjectModelOperation getEntity = addOperation(resultClass, "getEntity",
                    "<T extends org.nuiton.topia.persistence.TopiaEntity> T", ObjectModelModifier.PROTECTED);
            addParameter(getEntity, "java.util.Collection<T>", "childs");
            addParameter(getEntity, "java.lang.String", "topiaId");
            setOperationBody(getEntity, ""
    /*{
        if (childs != null) {
            for (T o : childs) {
                if (topiaId.equals(o.getTopiaId())) {
                    return o;
                }
            }
        }
        return null;
    }*/
            );
        }

        // Set body for default constructor
        setOperationBody(constructor, ""
    /*{
        pcs = new PropertyChangeSupport(this);<%=initTabs%>
    }*/
        );

        // Add operations
        for (ObjectModelOperation op : clazz.getOperations()) {
            String visibility = op.getVisibility();
            ObjectModelOperation resultOperation = addOperation(resultClass, op.getName(), op.getReturnType(),
                     ObjectModelModifier.toValue(visibility), ObjectModelModifier.ABSTRACT);

            for (ObjectModelParameter param : op.getParameters()) {
                addParameter(resultOperation, param.getType(), param.getName());
            }

            for (String exception : op.getExceptions()) {
                addException(resultOperation, exception);
            }
        }

        // Add toString operation        
        ObjectModelOperation toString = addOperation(resultClass, "toString", "java.lang.String",
                ObjectModelModifier.PUBLIC); // FIXME manque Override
        addImport(resultClass, "org.apache.commons.lang.builder.ToStringBuilder");
        setOperationBody(toString, ""
    /*{
        String result = new ToStringBuilder(this)<%=toStringAppend%>.
                toString();
        return result;
    }*/
        );

    }

    private void createForDTO(ObjectModelClass resultClass, ObjectModelClass inputClass, List<ObjectModelAttribute> attributes) {

        // Add Serializable implements for DTO generation
        if (!inputClass.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
            return;

        }

        addInterface(resultClass, "java.io.Serializable");
        String svUID = TopiaGeneratorUtil.findTagValue("dto-serialVersionUID", inputClass, getModel());
        if (svUID != null) {
            addConstant(resultClass, "serialVersionUID", "long", svUID, ObjectModelModifier.PUBLIC);
        }

        for (ObjectModelDependency dependency : inputClass.getDependencies()) {
            ObjectModelClass supplier = (ObjectModelClass)dependency.getSupplier();

            // ENTITY dependency
            // Copy all primitives attributes from the Entity (supplier) to the DTO
            // Prepare a list to future generation of all object generated attributes
            if (supplier.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                if (log.isInfoEnabled()) {
                    log.info("Create primitive and date fields in DTO from Entity : "
                            + supplier.getQualifiedName());
                }
                for (ObjectModelAttribute attr : supplier.getAttributes()) {
                    if (TopiaGeneratorUtil.isPrimitiveType(attr) || TopiaGeneratorUtil.isDateType(attr)) {
                        attributes.add(attr);
                    }
                }
            }
        }
    }

    protected void createListeners(ObjectModelClass resultClass, ObjectModelClass inputClass) {

        addAttribute(resultClass, "pcs", "java.beans.PropertyChangeSupport", "",
                ObjectModelModifier.PROTECTED, ObjectModelModifier.FINAL);

        // Add PropertyListener
        String propType = "java.beans.PropertyChangeListener";
        String strType = String.class.getName();
        String objectType = Object.class.getName();

        ObjectModelOperation addPropertyChangeListener = addOperation(resultClass,
                "addPropertyChangeListener", "void", ObjectModelModifier.PUBLIC);
        addParameter(addPropertyChangeListener, propType, "listener");
        setOperationBody(addPropertyChangeListener, ""
    /*{
        pcs.addPropertyChangeListener(listener);
    }*/
        );

        ObjectModelOperation addPropertyChangeListenerPlus = addOperation(resultClass,
                "addPropertyChangeListener", "void", ObjectModelModifier.PUBLIC);
        addParameter(addPropertyChangeListenerPlus, strType, "propertyName");
        addParameter(addPropertyChangeListenerPlus, propType, "listener");
        setOperationBody(addPropertyChangeListenerPlus, ""
    /*{
        pcs.addPropertyChangeListener(propertyName, listener);
    }*/
        );

        ObjectModelOperation removePropertyChangeListener = addOperation(resultClass,
                "removePropertyChangeListener", "void", ObjectModelModifier.PUBLIC);
        addParameter(removePropertyChangeListener, propType, "listener");
        setOperationBody(removePropertyChangeListener, ""
    /*{
        pcs.removePropertyChangeListener(listener);
    }*/
        );

        ObjectModelOperation removePropertyChangeListenerPlus = addOperation(resultClass,
                "removePropertyChangeListener", "void", ObjectModelModifier.PUBLIC);
        addParameter(removePropertyChangeListenerPlus, strType, "propertyName");
        addParameter(removePropertyChangeListenerPlus, propType, "listener");
        setOperationBody(removePropertyChangeListenerPlus, ""
    /*{
        pcs.removePropertyChangeListener(propertyName, listener);
    }*/
        );

        ObjectModelOperation firePropertyChange = addOperation(resultClass,
                "firePropertyChange", "void", ObjectModelModifier.PROTECTED);
        addParameter(firePropertyChange, strType, "propertyName");
        addParameter(firePropertyChange, objectType, "oldValue");
        addParameter(firePropertyChange, objectType, "newValue");
        setOperationBody(firePropertyChange, ""
    /*{
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }*/
        );
    }


}
